//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// julia.h
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2005 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 
//*******************************************************************************************
#ifndef TV_JULIA_H
#define TV_JULIA_H
using namespace std;
#include "object3d.h"

// Definition
// Julia object
class Julia : public Object3D_with_material {
	private:
		ObjParam_point *translate;
		ObjParam_scale *scale;
		ObjParam_rotation *rotation;
		ObjParam_option_combo *algebra, *function;
		ObjParam_int *max_iteration;
		ObjParam_float *precision;
		ObjParam_vector4 *julia_param, *slice;
		ObjParam_float *distance;

	public:
		Julia( app_objs *appref );
		Julia( Julia & ref );
		~Julia();
		Object3D *duplicate_yourself() { Julia *res = new Julia( *this ); return res; }

		void display( glview *view, bool set_color = true );
		void edit_widget( GtkWidget *wid );
		void destroy_editor();
		void pref_changed();
		
		void mouse_drag( struct drag_info *drag );
		float *get_location() { return translate->get(); }
		Rotation *get_rotation() { return rotation->get_rotation(); }
		
		void output_to_povray_pass1( ofstream & file );
		void save( ofstream & file );
		bool load( ifstream & file, char *tag );
};
#endif
