//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// lathe.h
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2005 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 
//*******************************************************************************************
#ifndef TV_LATHE_H
#define TV_LATHE_H
using namespace std;
#include "object3d.h"
#include "spline2d.h"



// Definition
class Lathe : public Object3D_with_material {
	#define SENDER ((Lathe*)data)
	friend void sign_lathe_current_point_num_changed( GtkWidget *wid, gpointer data ) { SENDER->current_point_num_changed(); }
	friend void sign_lathe_current_point_changed( GtkWidget *wid, gpointer data ) { SENDER->current_point_changed(); }
	friend void sign_lathe_delete_point( GtkWidget *wid, gpointer data ) { SENDER->delete_point(); }
	friend void sign_lathe_append_point( GtkWidget *wid, gpointer data ) { SENDER->append_point(); }
	friend void sign_lathe_prepend_point( GtkWidget *wid, gpointer data ) { SENDER->prepend_point(); }
	friend void sign_lathe_insert_point( GtkWidget *wid, gpointer data ) { SENDER->insert_point(); }
	#undef SENDER

	private:
		ObjParam_point *location;
		ObjParam_scale *size;
		ObjParam_rotation *rotation;
		Spline2D *spline;
		ObjParam_bool_activator *edit;
		ObjParam_bool *sturm;
		ObjParam_option_combo *spline_type;
	
		GtkWidget *spline_edit_box;
		ObjParam_int *current_point_num;
		ObjParam_point_2d *current_point;
		ObjParam_point_2d *current_point_ctrl1;
		ObjParam_point_2d *current_point_ctrl2;
		int selected_ctrl;
		bool in_undo;
		bool in_update;

	public:
		Lathe( app_objs *appref );
		Lathe( Lathe & ref );
		~Lathe();
		Object3D *duplicate_yourself() { Lathe *res = new Lathe( *this ); return res; }
		void add_to_tree( GtkWidget *view, GtkTreeStore *store, GtkTreeSelection *sel, GtkTreeIter *parent, GtkTreeIter *sibling, const gchar *pixmap = NULL ) { Object3D::add_to_tree( view, store, sel, parent, sibling, "object_lathe.xpm" ); }

		void display( glview *view, bool set_col = true );
		void edit_widget( GtkWidget *wid );
		void destroy_editor();
		void pref_changed();
		
		void mouse_drag( struct drag_info *drag );
		float *get_location() { return location->get(); }
		Rotation *get_rotation() { return rotation->get_rotation(); }
		
		void output_to_povray_pass1( ofstream & file );
		void save( ofstream & file );
		bool load( ifstream & file, char *tag );
		
		void current_point_num_changed();		
		void current_point_changed();
		void delete_point();
		void append_point();
		void prepend_point();
		void insert_point();		
		virtual bool pick_test( int name );
		void undo( Object3D *copy );
		void push_undo_item() { if ( !in_undo && !in_update ) Object3D::push_undo_item(); }
};
#endif
