//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// lights.cc
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2005 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 
//*******************************************************************************************
#ifndef TV_LIGHTS_H
#define TV_LIGHTS_H
using namespace std;
#include "object3d.h"

// Dfinition
class PointLight : public Object3D {
	protected:
		ObjParam_point *location;
		ObjParam_bool *media_attenuation;
		ObjParam_bool *media_interaction;
		ObjParam_color *color;
		ObjParam_bool *parallel;

		ObjParam_bool_activator *fade;
		ObjParam_float *fade_distance, *fade_power;
		ObjParam_bool *refraction, *reflection, *area;
		ObjParam_objref *look_like, *projected_through;
		int light_id;

	public:
		PointLight( app_objs *appref );
		PointLight( PointLight & ref );
		~PointLight();
		Object3D *duplicate_yourself() { PointLight *res = new PointLight( *this ); return res; }
		
		void add_to_tree( GtkWidget *view, GtkTreeStore *store, GtkTreeSelection *sel, GtkTreeIter *parent, GtkTreeIter *sibling, const gchar *pixmap = NULL ) { Object3D::add_to_tree( view, store, sel, parent, sibling, "object_light.xpm" ); }

		virtual void display( glview *view, bool set_color = true );
		virtual void edit_widget( GtkWidget *wid );
		virtual void destroy_editor();
		virtual void pref_changed();
		virtual void mouse_drag( struct drag_info *drag );
		
		virtual void output_to_povray_pass1( ofstream & file );
		virtual void output_to_povray_pass2( ofstream & file ) { if ( !render->value() ) return; file << "\n\t"; get_underscore_name( file );  }
		virtual void save( ofstream & file );
		virtual bool load( ifstream & file, char *tag );

		// Access methods
		virtual void set_location(float *data) { location->set(data[0], data[1], data[2]); location->update_widget(); }
		float *get_location() { return location->get(); }

		bool is_media_attenuation() { return media_attenuation->value(); }
		void set_media_attenuation( bool b ) { media_attenuation->set( b );media_attenuation->update_widget(); }

		bool is_media_interaction() { return media_interaction->value(); }
		void set_media_interaction( bool b ) { media_interaction->set( b );media_interaction->update_widget(); }

		bool is_parallel() { return parallel->value(); }
		void set_parallel( bool b ) { parallel->set( b ); parallel->update_widget();}

		bool is_refraction() { return refraction->value(); }
		void set_refraction( bool b ) { refraction->set( b ); refraction->update_widget();}
		
		bool is_reflection() { return reflection->value(); }
		void set_reflection( bool b ) { reflection->set( b ); reflection->update_widget();}

		bool is_fade() { return fade->value(); }
		void set_fade( bool b ) { fade->set( b ); fade->update_widget();}

		bool is_area() { return area->value(); }
		void set_area( bool b ) { area->set( b ); area->update_widget();}

		double *get_light_color() { return color->get(); }
		void set_light_color(double *data) { color->set(data[0], data[1], data[2]); color->update_widget();}

		float get_fade_distance() { return fade_distance->value(); }
		void set_fade_distance(float data) { fade_distance->set(data); fade_distance->update_widget();}

		float get_fade_power() { return fade_power->value(); }
		void set_fade_power(float data) { fade_power->set(data); fade_power->update_widget();}
};

class AreaLight : public  PointLight {
	private:
		ObjParam_point *size;
		ObjParam_rotation *rotation;
		ObjParam_int *sizex;
		ObjParam_int *sizez;
		ObjParam_bool  *jitter;
		ObjParam_int *adaptive;
		ObjParam_bool *circular;
		ObjParam_bool *orient;
		ObjParam_bool *parallel;
		
	public:
		AreaLight( app_objs *app_ref );
		AreaLight( AreaLight & ref );
		~AreaLight();
		Object3D *duplicate_yourself() { AreaLight *res = new AreaLight( *this ); return res; }
		
		void display( glview *view, bool set_color = true );
		void edit_widget( GtkWidget *wid );
		void destroy_editor();
		void pref_changed();
		void mouse_drag( struct drag_info *drag );
		
		void output_to_povray_pass1( ofstream & file );
		virtual void output_to_povray_pass2( ofstream & file ) { if ( !render->value() ) return; file << "\n\t"; get_underscore_name( file );  }
		void save( ofstream & file );
		bool load( ifstream & file, char *tag );

		// Access methods

		int get_size_x() { return sizex->value(); }
		void set_size_x(int data) { sizex->set(data); sizex->update_widget();}
		
		int get_size_z() { return sizez->value(); }
		void set_size_z(int data) { sizez->set(data); sizez->update_widget();}
		
		int get_adaptive() { return adaptive->value(); }
		void set_adaptive(int data) { adaptive->set(data); adaptive->update_widget();}
		
		bool is_parallel() { return parallel->value(); }
		void set_parallel( bool b ) { parallel->set( b ); parallel->update_widget();}

		bool is_jitter() { return jitter->value(); }
		void set_jitter( bool b ) { jitter->set( b ); jitter->update_widget();}
		
		bool is_circular() { return circular->value(); }
		void set_circular( bool b ) { circular->set( b ); circular->update_widget();}

		bool is_orient() { return orient->value(); }
		void set_orient( bool b ) { orient->set( b ); orient->update_widget();}
		
		float* get_rot(float* val) { float _x, _y, _z; rotation->get(_x, _y, _z); val[0] = _x; val[1] = _y; val[2] = _z; return (float*)val;}
		void set_rotation(float *data) {rotation->set(data[0], data[1], data[2]); rotation->update_widget(); rotation->flush();}
		
		float* get_size() { return size->get(); }
		void set_size(float *data) { size->set(data[0], data[1], data[2]); size->update_widget();}
};


// SpotLight
class SpotLight : public Object3D {
	protected:
		ObjParam_point *location;
		ObjParam_bool *media_attenuation;
		ObjParam_bool *media_interaction;
		ObjParam_color *color;
		ObjParam_float *radius;
		ObjParam_float *falloff;
		ObjParam_int *tightness;
		ObjParam_point *pointat;
		ObjParam_bool *frustum;
		ObjParam_bool *parallel;
		ObjParam_bool *refraction, *reflection, *area;

		ObjParam_bool_activator *fade;
		ObjParam_float *fade_distance, *fade_power;
		ObjParam_objref *look_like, *projected_through;
		int light_id;

	public:
		SpotLight( app_objs *appref );
		SpotLight( SpotLight & ref );
		~SpotLight();
		Object3D *duplicate_yourself() { SpotLight *res = new SpotLight( *this ); return res; }
		
		void add_to_tree( GtkWidget *view, GtkTreeStore *store, GtkTreeSelection *sel, GtkTreeIter *parent, GtkTreeIter *sibling, const gchar *pixmap = NULL ) { Object3D::add_to_tree( view, store, sel, parent, sibling, "object_light.xpm" ); }

		void display( glview *view, bool set_color = true );
		void edit_widget( GtkWidget *wid );
		void destroy_editor();
		void pref_changed();
		void mouse_drag( struct drag_info *drag );	
		void output_to_povray_pass1( ofstream & file );
		virtual void output_to_povray_pass2( ofstream & file ) { if ( !render->value() ) return; file << "\n\t"; get_underscore_name( file );  }
		virtual void save( ofstream & file );
		virtual bool load( ifstream & file, char *tag );

		// Access methods
		virtual void set_location(float *data) { location->set(data[0], data[1], data[2]); location->update_widget(); }
		float *get_location() { return location->get(); }

		bool is_media_attenuation() { return media_attenuation->value(); }
		void set_media_attenuation( bool b ) { media_attenuation->set( b );media_attenuation->update_widget(); }

		bool is_media_interaction() { return media_interaction->value(); }
		void set_media_interaction( bool b ) { media_interaction->set( b );media_interaction->update_widget(); }

		bool is_parallel() { return parallel->value(); }
		void set_parallel( bool b ) { parallel->set( b ); parallel->update_widget();}

		bool is_refraction() { return refraction->value(); }
		void set_refraction( bool b ) { refraction->set( b ); refraction->update_widget();}
		
		bool is_reflection() { return reflection->value(); }
		void set_reflection( bool b ) { reflection->set( b ); reflection->update_widget();}

		bool is_fade() { return fade->value(); }
		void set_fade( bool b ) { fade->set( b ); fade->update_widget();}

		bool is_area() { return area->value(); }
		void set_area( bool b ) { area->set( b ); area->update_widget();}

		double *get_light_color() { return color->get(); }
		void set_light_color(double *data) { color->set(data[0], data[1], data[2]); color->update_widget();}

		float get_fade_distance() { return fade_distance->value(); }
		void set_fade_distance(float data) { fade_distance->set(data); fade_distance->update_widget();}

		float get_fade_power() { return fade_power->value(); }
		void set_fade_power(float data) { fade_power->set(data); fade_power->update_widget();}

		float *get_point_at() { return pointat->get(); }
		void set_point_at(float *data) { pointat->set(data[0], data[1], data[2]); pointat->update_widget(); }

		bool is_show_frustum() { return frustum->value(); }
		void set_show_frustum( bool b ) { frustum->set( b ); frustum->update_widget();}

		int get_tightness() { return tightness->value(); }
		void set_tightness(int data) { tightness->set(data); tightness->update_widget();}

		float get_falloff() { return falloff->value(); }
		void set_falloff(float data) { falloff->set(data); falloff->update_widget();}

		float get_radius() { return radius->value(); }
		void set_radius(float data) { radius->set(data); radius->update_widget();}
};

// Cylindrical light
class CylindricalLight : public SpotLight {
	public:
		CylindricalLight( app_objs *app_ref );
		CylindricalLight( CylindricalLight & ref ) : SpotLight( ref ) {}
		void display( glview *view, bool set_color = true );
		void output_to_povray_pass1( ofstream & file );		
		virtual void output_to_povray_pass2( ofstream & file ) { if ( !render->value() ) return; file << "\n\t"; get_underscore_name( file );  }
		void save( ofstream & file );
		bool load( ifstream & file, char *tag );
};

#endif
