//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// linkobj.h
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2005 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 
//*******************************************************************************************
#ifndef TV_LINKOBJ_H
#define TV_LINKOBJ_H
using namespace std;
#include "object3d.h"

// Definition
// Box object
class LinkObj : public Object3D {
	private:
		ObjParam_objref *link;
		ObjParam_point *translation;
		ObjParam_scale *size;
		ObjParam_rotation *rotation;

	public:
		LinkObj( app_objs *appref );
		LinkObj( LinkObj & ref );
		~LinkObj();
		Object3D *duplicate_yourself() { LinkObj *res = new LinkObj( *this ); return res; }
		void add_to_tree( GtkWidget *view, GtkTreeStore *store, GtkTreeSelection *sel, GtkTreeIter *parent, GtkTreeIter *sibling, const gchar *pixmap = NULL ) { Object3D::add_to_tree( view, store, sel, parent, sibling, "object_link.xpm" ); }

		void display( glview *view, bool set_color = true );
		void edit_widget( GtkWidget *wid );
		void destroy_editor();
		void pref_changed();
		
		void mouse_drag( struct drag_info *drag );
		float *get_location() { return translation->get(); }
		Rotation *get_rotation() { return rotation->get_rotation(); }
		
		void output_to_povray_pass2( ofstream & file );
		void save( ofstream & file );
		bool load( ifstream & file, char *tag );
};
#endif
