//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// main.h
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2005 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 
//*******************************************************************************************
#ifndef MAIN_H
#define MAIN_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

using namespace std;
#include <stdlib.h>
#include <iostream>
#include <libgnome/gnome-i18n.h>
#include <locale.h>
#include <glib.h>
#include "gnome.h"

// Definitions
#define APP_NAME "Truevision"
#define APP_COPY "(c) 2000-2005 The Free Software Foundation"
#define APP_DESCR "3D modeler for Gnome"
#define APP_AUTHORS { "Vincent LE PRINCE", "Christian SPOER", NULL }

// Global objects base definitions
// these objects are to be called from anywhere in the sources
// with a definition like 'PREF_DEF'
// Need main.h inclusion
class app_object {
	public:
		virtual ~app_object() {}
		virtual void pref_changed() {}
};


// Global objects
// & program parameters
struct app_objs {
	GnomeProgram *app;
	int argc;
	char **argv;
	char **envp;
	char *file_to_load;
	app_object *interf;
	app_object *prefer;
	app_object *vmanager;
	app_object *proppanel;
	//app_object *toolbar;
	app_object *obj3dlist;
	app_object *scene;
	app_object *matlist;
	app_object *povfe;
	app_object *matlib;
	app_object *undoman;
	app_object *python_engine;
	app_object *pyscript_db;
};


// General use functions
// dialog boxes for warnings, fatal errors & about dialog.
gboolean app_exit( GtkWidget *widget, GdkEvent *event, gpointer data );
void app_destroy( GtkWidget *widget, gpointer data );
void app_fatal_err( const char *message );
void app_warning( const char *message );
void app_warning( const char *message, const char *message2 );
void about();
void display_homepage(); 
void help_index();
void truevision_help_display( char *file, char *sect, char *sub = NULL );
app_objs *tv_get_obj_ref();

#endif
