//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// material.h
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2005 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 
//*******************************************************************************************
#ifndef TV_TEXTURE_H
#define TV_TEXTURE_H
using namespace std;
#include "main.h"
#include <iostream>
#include <fstream>
#include "tvwidgets.h"

//**********************************************************
// Material item types
//**********************************************************
enum matit_type {
	TV_MITEM_MATERIAL = 0,
	TV_MITEM_TEXTURE,
	TV_MITEM_INTERIOR,
	TV_MITEM_FINISH,
	TV_MITEM_PIGMENT,
	TV_MITEM_NORMAL,
	TV_MITEM_MEDIA,
	TV_MITEM_DENSITY,
};
typedef matit_type MaterialItemType;


//****************************************************
// Classe Item de Texture
//****************************************************
class MaterialItem {
	#define SENDER ((MaterialItem*)data)
	friend void sign_miname_changed( GtkWidget *wid, gpointer data ) { SENDER->name_changed(); }
	#undef SENDER

	protected:
		static app_objs *app_ref;
		MaterialItemType item_type;
		GtkTreeStore *tree_store;
		GtkTreeIter node_iter;
		bool in_tree;
		GtkTreeIter *tree_node_parent;
		GtkTreeView *tree_view;
		GtkTreeSelection *tree_selection;
		GtkWidget *widget;
		GtkWidget *edit_cont;
		TvWidget_entry *name;
		TvWidget_bool *expand;
		char *sname;

	public:
		MaterialItem( app_objs *appref, char *sname );
		MaterialItem( MaterialItem & ref );
		virtual MaterialItem *duplicate_yourself() { MaterialItem *res = new MaterialItem( *this ); return res; }
		
		char *get_name() { return name->value(); }
		MaterialItemType get_type() { return item_type; }
		char *get_previous_name() { return name->get_previous_value(); }
		virtual void set_name( char *nom );
		virtual void name_changed();
		
		virtual void add_to_tree( GtkTreeView *view, GtkTreeStore *store, GtkTreeSelection *selection, GtkTreeIter *parent, GtkTreeIter *sibling = NULL  );
		void reset_name_in_tree( char *iname ) { gtk_tree_store_set( tree_store, &node_iter, 0, iname, -1 ); }
		virtual void remove_from_tree();
		void clear_tree_node() { gtk_tree_iter_free( &node_iter ); }

		virtual void delete_yourself() {}
		virtual void move_yourself( int sens ) {}
		
		virtual void edit_widget( GtkWidget *box, char *type );
		virtual void edit_widget( GtkWidget *box ) {}
		virtual void destroy_widget() { if ( widget != NULL ) gtk_widget_destroy(widget); widget = NULL; edit_cont = NULL; }
		virtual void flush() { name->flush(); }
		virtual bool is_used() { return true; }
		virtual void output_to_povray( ofstream & file ) {}
		GtkTreeIter *get_tree_node_iter() { return &node_iter; }
		virtual void save_node_state();
		virtual void set_node_state();
		void select_tree_row() { gtk_tree_selection_select_iter( tree_selection, &node_iter ); }

		virtual void save( ofstream &file ) {}
		virtual bool load( ifstream &file ) { return false; }
		virtual bool load( ifstream & file, char *tag ) { return false; }
		
		virtual bool paste( MaterialItem *item ) { return false; }
		void paste_basics( MaterialItem *item );
};



//****************************************************
// Material types
//****************************************************
enum mattypes {
	TV_MAT_POV,
	};
typedef mattypes MaterialType;


//****************************************************
// Classe Texture de base
//****************************************************
class Material : public MaterialItem {
	#define SENDER ((Material*)data)
	friend void sign_name_focusout( GtkWidget *wid, GdkEvent *ev, gpointer data ) { SENDER->name_edition_finished(); }
	#undef SENDER

	protected:
		MaterialType type;
		GtkCList *clist;

		GtkWidget *box_editor;
		MaterialItem *current;
		void set_name( char *nm );
		void name_changed();
		void name_edition_finished() { if ( ! name->in_update ) name->update_widget();  }
		
	public:
		TvWidget_entry *author;
		TvWidget_text *comment;
	
	public:
		Material( app_objs *appref, char *sname );
		virtual ~Material();
		char *get_name() { return name->value(); }
		MaterialType get_type() { return type; }
		virtual void add_to_list( GtkListStore *store, int pos = -1 );
		
		virtual void get_editor( GtkTreeView *view, GtkTreeStore *tree, GtkTreeSelection *selection, GtkWidget *box );
		void mat_tree_select( GtkTreeSelection *selection );
		void delete_mat_item(  );
		void move_mat_item( int sens );
		MaterialItem *get_selected_item() { return current; }
		
		virtual void edit_widget( GtkWidget *box ) { MaterialItem::edit_widget( box, _("Material") ); name->connect_signal2( GTK_SIGNAL_FUNC(sign_name_focusout), this );  }
		virtual void destroy_widget() { MaterialItem::destroy_widget(); name->clear_widget();  }

		virtual void destroy_editor();
		virtual void flush_material() { if ( current != NULL ) current->flush(); }
		virtual void flush() {}
		virtual void output_to_povray( ofstream & file ) {}
		void get_underscore_name( ofstream & file );

		virtual void set_gl_material() {}
};

#endif
