//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// matlib.h
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2005 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */
//*******************************************************************************************
#ifndef TV_MATLIB_H
#define TV_MATLIB_H
using namespace std;
#include <vector>
#include "main.h"
#include "tvwidgets.h"

//******************************************************
// Material library tree Item
//******************************************************
class MatLibItem {
	#define SENDER ((MatLibItem*)data)
	friend bool compare_items( MatLibItem *item1, MatLibItem *item2 );
	friend void sign_thumb_data_free( guchar *data, gpointer sender ) { delete SENDER->data; }
	#undef SENDER

	private:
		static app_objs *app_ref;
		char *name;
		char *path;
		char *real_name;
		char* author;
		char *comment;
		char *data;
			
	public:
		MatLibItem( char *path, char *name, app_objs *appref  );
		~MatLibItem();		
		
		void draw_thumb( GtkWidget *view, GtkListStore *store );
		void show_info( TvWidget_entry *name_label, TvWidget_entry *author_label, TvWidget_text *description );
		void load();
};
			

//*********************************************************
// Material library tree node
//********************************************************
class MatLibNode {
	friend bool compare_nodes( MatLibNode*node1, MatLibNode *node2 );

	private:
		static app_objs *app_ref;
		char *name;
		char *systempath;
		char *homepath;
	
		static GtkWidget *tree_view;
		static GtkTreeStore *tree_store;
		static GtkTreeSelection *tree_selection;
		GtkTreeIter node_iter;
		
		vector <MatLibNode*> SubNodes;
		vector <MatLibItem*> Children;
		
	public:
		MatLibNode( char *systempath, char *homepath, char *name, app_objs *appref  );
		~MatLibNode();
		
		void add_to_tree( GtkWidget *view, GtkTreeStore *store, GtkTreeSelection *selection, GtkTreeIter *parent );
		void select( ) { gtk_tree_selection_select_iter( tree_selection, &node_iter );}
		void expand();
		void draw_thumbs( GtkWidget *view, GtkListStore *store, GtkWidget *progress, GtkWidget *label );
};



//*******************************************************
// The material library
//*******************************************************
#define MATLIB_DEF MatLib *matlib = (MatLib*)(app_ref->matlib);


class MatLib : public app_object {
	
	// Gtk Callbacks
	#define SENDER ((MatLib*)data)
	friend void sign_matlib_dlg_click( GtkDialog *wid, gint button, gpointer data ) { SENDER->clicked_dlg(button); }
	friend void sign_matlib_dlg_destroy( GtkWidget *wid, GdkEvent *ev, gpointer data ) { SENDER->clicked_dlg(-1); }		

	friend void sign_matlib_icon_select( GtkIconView *view, gpointer data ) { SENDER->icon_select( ); }		
	friend void sign_matlib_icon_doubleclick( GtkIconView *view, GtkTreePath *path, gpointer data ) { SENDER->icon_doubleclick( path ); }		

	friend void sign_matlib_tree_select( GtkTreeSelection *selection, gpointer data ) { SENDER->tree_select( selection ); }		
	friend void sign_matlib_tree_doubleclick( GtkTreeView* view, GtkTreePath *path, GtkTreeViewColumn *col, gpointer data ) { SENDER->tree_doubleclick(); }		
	friend void sign_matlib_open( GtkWidget *wid, gpointer data ) { SENDER->raise_dlg_box(); }	
	#undef SENDER


	private:
		app_objs *app_ref;
		char *systemlib;
		char *homelib;
		bool freeze;
	
		// The material icon view
		GtkWidget *material_icon_view;
		GtkListStore *material_icon_store;
		GtkTreeSelection *material_icon_selection;
			
		// The material selection tree
		GtkTreeStore *material_tree_store;
		GtkWidget *material_tree_view;
		GtkTreeSelection *material_tree_selection;

		// Dialog and widgets	
		GtkWidget *dialog;
		GtkWidget *progress_bar;
		GtkWidget *label;
		TvWidget_entry *name_label, *author_label;
		TvWidget_text *description;
		MatLibNode *root, *selected_node;
		
		void tree_select( GtkTreeSelection *selection );
		void tree_doubleclick();		

		void clicked_dlg( int button );
		
		void icon_select();
		void load_selection();
		void icon_doubleclick( GtkTreePath *path );
	
	public:
		MatLib( app_objs *appref );
		~MatLib();
			
		void raise_dlg_box();
};
#endif
