//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// media.h
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2001 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 
//*******************************************************************************************
#ifndef MEDIA_H
#define MEDIA_H
using namespace std;
#include "material.h"
#include "density.h"
#include <vector>

//****************************************************
// Classe scattering
//****************************************************
class TvWidget_scattering : public TvWidget {
	protected:
		TvWidget_bool_activator *use_scattering;
		TvWidget_option_combo *type;
		TvWidget_float *eccentricity;
		TvWidget_float *extinction;
		TvWidget_pigment *color;

	public:
		TvWidget_scattering(  const char *name, const char *sname, const char *tooltip, app_objs *appref );
		TvWidget_scattering( TvWidget_scattering & ref );
		virtual ~TvWidget_scattering();

		void get_widget_wnframe( GtkWidget *box, bool tt, bool frame );
		void get_widget_noframe( GtkWidget *box, bool tt )  {  get_widget_wnframe( box, tt, false ); }
		void get_widget( GtkWidget *box, bool tt ) {  get_widget_wnframe( box, tt, true ); }
		void clear_widget();
		void flush();
		void output_to_povray( ofstream & file );
		void save( ofstream & file );
		bool load( ifstream & file, char * tag );
};

class TvWidget_scattering_rb : public TvWidget_scattering  {
	protected:
		Rolling_box *rb;

	public:
		TvWidget_scattering_rb( const char *name, const char *sname, const char *tooltip, app_objs *appref )
			: TvWidget_scattering( name, sname, tooltip, appref )
			{ rb = new Rolling_box( name, app_ref, (TvWidget*)this ); }

		void get_widget_rb( GtkWidget *box, bool tt ) { rb->get_widget_rb( box, tt ); }
};



//****************************************************
// Classe Media
//****************************************************
class PovTexMedia : public MaterialItem {
	#define SENDER ((PovTexMedia*)data)
	friend void sign_media_delete( GtkWidget *wid, gpointer data ) { SENDER->del_media(); }
	friend void sign_media_add_density( GtkWidget *wid, gpointer data ) { SENDER->add_density(); }
	friend void sign_media_density_suicide( gpointer data, gpointer victim ) { SENDER->delete_density( (PovTexDensity*)victim ); }
	#undef SENDER

	private:
		static int count;
		int num;
		gpointer mother;
		void (*suicidal_func)(gpointer, gpointer);
		vector<PovTexDensity*> density_liste;

		TvWidget_int *intervals;
		TvWidget_int *sample_min, *sample_max;
		TvWidget_float *confidence;
		TvWidget_float *variance;
		TvWidget_float *ratio;
		TvWidget_float *jitter;
		TvWidget_int *aa_level;
		TvWidget_float *aa_threshold;
		TvWidget_option_combo *sampling_method;
		TvWidget_pigment_rb *absorption, *emission;
		TvWidget_scattering_rb *scattering;
		TvWidget_transformation_rb *transfo;

	public:
		PovTexMedia( app_objs *appref, char *tagname, void (*suicidal_func)(gpointer, gpointer), gpointer mother );
		PovTexMedia( PovTexMedia & ref );
		MaterialItem *duplicate_yourself() { PovTexMedia *res = new PovTexMedia( *this ); return res; }
		virtual ~PovTexMedia();
		void set_params(  void (*sf)(gpointer, gpointer), gpointer mum ) { suicidal_func = sf; mother = mum; }

		void edit_widget( GtkWidget *box );
		void destroy_widget();
		void add_to_tree( GtkTreeView *view, GtkTreeStore *store, GtkTreeSelection *selection, GtkTreeIter *parent, GtkTreeIter *sibling = NULL  );
		void remove_from_tree();
		void flush();
		void output_to_povray( ofstream & file );
		void save( ofstream & file );
		bool load( ifstream & file, char * tag );
		
		void del_media() { suicidal_func( mother, this ); }
		void delete_yourself() { del_media(); }

		void add_density();
		void delete_density( PovTexDensity * density );
		
		bool paste( MaterialItem *item );
		void save_node_state();
};

#endif
