//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// obj3dcsg.h
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2005 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */
//*******************************************************************************************
#ifndef TV_OBJ3DCSG_H
#define TV_OBJ3DCSG_H
using namespace std;
#include "object3d.h"
#include <vector>


// Dfinition
class ObjCSG : public Object3D_with_material {
	protected:
		ObjParam_point *translation;
		ObjParam_scale *size;
		ObjParam_rotation *rotation;
		TvWidget_bool *node_expanded;
		ObjParam_bool *evaluate;
		vector<Object3D*> children;

	public:
		ObjCSG( app_objs *appref );
		ObjCSG( ObjCSG & ref );
		~ObjCSG();

		virtual void display( glview *view, bool set_col = true  );
		virtual void edit_widget( GtkWidget *wid );
		virtual void destroy_editor();
		virtual void pref_changed();
		virtual void add_to_tree( GtkWidget *view, GtkTreeStore *store, GtkTreeSelection *sel, GtkTreeIter *parent, GtkTreeIter *sibling, const gchar *pixmap = NULL );

		virtual void save_tree();
		void set_layer( ObjectLayer *lay );

		void mouse_drag( struct drag_info *drag );
		float *get_location() { return translation->get(); }
		Rotation *get_rotation() { return rotation->get_rotation(); }

		void add_object( Object3D *obj );
		virtual bool is_group() { return true; }
		virtual int get_children_num() { return children.size(); }
		virtual Object3D* get_children( int i ) { return children[i]; }
		virtual void paste_object( Object3D *obj );	
		virtual void remove_object( Object3D *obj );
		virtual void duplicate_object( Object3D *obj );	
		virtual void move_child_up( Object3D *obj );
		virtual void move_child_down( Object3D *obj );
		virtual int get_child_pos( Object3D *obj ) { unsigned int i; for ( i = 0 ; i < children.size() ; i++ ) if ( children[i] == obj ) break; return i; }
		virtual void insert_child( Object3D *obj, int position );
		virtual bool has_as_ancester( Object3D *obj );
		
		virtual void save_children( ofstream & file );
		virtual void load_children( ifstream & file );
		void get_materials( vector<Material*> & mlist ) { for ( unsigned int i = 0 ; i <  children.size() ; i ++ ) children[i]->get_materials( mlist ); Object3D_with_material::get_materials(mlist); }

		// Access methods
		virtual void set_location(float *data) {translation->set(data[0], data[1], data[2]); }
		void set_rotation(float *data) {rotation->set(data[0], data[1], data[2]); rotation->update_widget(); rotation->flush();}
		void set_size(float *data) { size->set(data[0], data[1], data[2]);}
		float* get_rot(float* val) { float _x, _y, _z; rotation->get(_x, _y, _z); val[0] = _x; val[1] = _y; val[2] = _z; return (float*)val;}
		float* get_size() { return size->get(); }
		bool is_evaluate() { return evaluate->value(); }
		void set_evaluate( bool b ) { evaluate->set(b); }
		
};


// Modified CSG for INtersection / Difference texture cutaway
class CsgCutAway : public ObjCSG {
	protected:
		ObjParam_bool *cutaway_textures;

	public:
		CsgCutAway( app_objs *appref ) : ObjCSG( appref) { cutaway_textures = new ObjParam_bool( N_("Cutaway textures"), "CUTTEX", NULL, appref, false, false ); }
		CsgCutAway( CsgCutAway & ref ) : ObjCSG( ref ) { cutaway_textures = new ObjParam_bool( *ref.cutaway_textures ); }
		~CsgCutAway() { delete cutaway_textures; }

		CsgCutAway *duplicate_yourself() { CsgCutAway *res = new CsgCutAway( *this ); return res; }		
		virtual void edit_widget( GtkWidget *wid );
		void destroy_editor() { ObjCSG::destroy_editor(); cutaway_textures->clear_widget(); }
		void pref_changed() { ObjCSG::pref_changed(); cutaway_textures->pref_changed(); }
		virtual void save_children( ofstream & file ) { ObjCSG::save_children( file ); }
		virtual void load_children( ifstream & file );

		// Access methods
		bool is_cutaway() { return cutaway_textures->value(); }
		void set_cutaway( bool b ) { cutaway_textures->set( b ); }
};


class CsgUnion : public ObjCSG {
	protected:
		TvWidget_bool *split_union;
	
	public:
		CsgUnion( app_objs *appref );
		CsgUnion *duplicate_yourself() { CsgUnion *res = new CsgUnion( *this ); return res; }		
		void add_to_tree( GtkWidget *view, GtkTreeStore *store, GtkTreeSelection *sel, GtkTreeIter *parent, GtkTreeIter *sibling, const gchar *pixmap = NULL ) { ObjCSG::add_to_tree( view, store, sel, parent, sibling, "object_union.xpm" ); }

		void output_to_povray_pass1( ofstream & file );
		void save( ofstream & file );
		bool load( ifstream & file, char *tag );		
		virtual void edit_widget( GtkWidget *wid );
};

class CsgGroup : public ObjCSG {
	protected:
	
	public:
		CsgGroup( app_objs *appref );
		CsgGroup *duplicate_yourself() { CsgGroup *res = new CsgGroup( *this ); return res; }		
		void add_to_tree( GtkWidget *view, GtkTreeStore *store, GtkTreeSelection *sel, GtkTreeIter *parent, GtkTreeIter *sibling, const gchar *pixmap = NULL ) { ObjCSG::add_to_tree( view, store, sel, parent, sibling, "object_default.xpm" ); }
		void output_to_povray_pass1( ofstream & file );
		void output_to_povray_pass2( ofstream & file );
		void save( ofstream & file );
		bool load( ifstream & file, char *tag );		
		virtual void edit_widget( GtkWidget *wid );
};

class CsgDifference : public CsgCutAway {
	private:
		void draw_a( glview *view );
		void draw_b( glview *view );

	public:
		CsgDifference( app_objs *appref );
		CsgDifference *duplicate_yourself() { CsgDifference *res = new CsgDifference( *this ); return res; }		
		void add_to_tree( GtkWidget *view, GtkTreeStore *store, GtkTreeSelection *sel, GtkTreeIter *parent, GtkTreeIter *sibling, const gchar *pixmap = NULL ) { ObjCSG::add_to_tree( view, store, sel, parent, sibling, "object_diff.xpm" ); }
		void output_to_povray_pass1( ofstream & file );
		void save( ofstream & file );
		bool load( ifstream & file, char *tag );
		virtual void display( glview *view, bool set_col = true );
};

class CsgMerge : public ObjCSG {
	public:
		CsgMerge( app_objs *appref );
		CsgMerge *duplicate_yourself() { CsgMerge *res = new CsgMerge( *this ); return res; }		
		void add_to_tree( GtkWidget *view, GtkTreeStore *store, GtkTreeSelection *sel, GtkTreeIter *parent, GtkTreeIter *sibling, const gchar *pixmap = NULL ) { ObjCSG::add_to_tree( view, store, sel, parent, sibling, "object_merge.xpm" ); }
		
		void output_to_povray_pass1( ofstream & file )	;
		void save( ofstream & file );
		bool load( ifstream & file, char *tag );
};

class CsgIntersection : public CsgCutAway {
	private:
		void draw_a( glview *view );
		void draw_b( glview *view );

	public:
		CsgIntersection( app_objs *appref );
		CsgIntersection *duplicate_yourself() { CsgIntersection *res = new CsgIntersection( *this ); return res; }		
		void add_to_tree( GtkWidget *view, GtkTreeStore *store, GtkTreeSelection *sel, GtkTreeIter *parent, GtkTreeIter *sibling, const gchar *pixmap = NULL ) { ObjCSG::add_to_tree( view, store, sel, parent, sibling, "object_inter.xpm" ); }
		
		void output_to_povray_pass1( ofstream & file );
		void save( ofstream & file );
		bool load( ifstream & file, char *tag );
		virtual void display( glview *view, bool set_col = true  );
};

class LightGroup : public ObjCSG {
	private:
		ObjParam_bool *global_lights;

	public:
		LightGroup( app_objs *appref );
		LightGroup *duplicate_yourself() { LightGroup *res = new LightGroup( *this ); return res; }		
		LightGroup( LightGroup & ref ) : ObjCSG( ref ) { global_lights = new ObjParam_bool( *ref.global_lights ); }
		~LightGroup() { delete global_lights; }
		virtual void pref_changed();
		void add_to_tree( GtkWidget *view, GtkTreeStore *store, GtkTreeSelection *sel, GtkTreeIter *parent, GtkTreeIter *sibling, const gchar *pixmap = NULL ) { ObjCSG::add_to_tree( view, store, sel, parent, sibling, "object_light.xpm" ); }
		
		virtual void edit_widget( GtkWidget *wid );
		virtual void destroy_editor();
		void output_to_povray_pass1( ofstream & file )	;
		void save( ofstream & file );
		bool load( ifstream & file, char *tag );
};
#endif
