//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// objdef.h
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2005 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 
//*******************************************************************************************
#ifndef TV_OBJ3DDEF_H
#define TV_OBJ3DDEF_H
using namespace std;
#include "objectlist.h"

// Lights
const int Lights_tree_num = 4;
static Object3DDef Lights_tree[Lights_tree_num] = {
	OBJ3D_INLINE_DEF( N_("Point Light"),  TV_OBJ3D_POINTLIGHT, "object_light.xpm", N_("A point light.") ),
	OBJ3D_INLINE_DEF( N_("Spot Light"),  TV_OBJ3D_SPOTLIGHT, "object_light.xpm", N_("A spot light.") ),
	OBJ3D_INLINE_DEF( N_("Cylindrical Light"),  TV_OBJ3D_CYLLIGHT, "object_light.xpm", N_("A cylindrical light.")),
	OBJ3D_INLINE_DEF( N_("Area Light"),  TV_OBJ3D_AREALIGHT, "object_light.xpm", N_("An area light.") ),
	}; 

// Finite Solid Primitives
const int FSP_tree_num = 14;
static Object3DDef FSP_tree[FSP_tree_num] = {
	OBJ3D_INLINE_DEF( N_("Blob"),  TV_OBJ3D_BLOB, "object_blob.xpm", N_("A Blob.") ),
	OBJ3D_INLINE_DEF( N_("Box"),  TV_OBJ3D_BOX, "object_box.xpm", N_("A simple box.") ),
	OBJ3D_INLINE_DEF( N_("Cone"),  TV_OBJ3D_CONE, "object_cone.xpm", N_("A cone.") ),
	OBJ3D_INLINE_DEF( N_("Cylinder"),  TV_OBJ3D_CYLINDER, "object_cylinder.xpm", N_("A cylinder.") ),
	OBJ3D_INLINE_DEF( N_("Heightfield"),  TV_OBJ3D_HEIGHTFIELD, "object_hf.xpm", N_("A heigthfield.") ),			
	OBJ3D_INLINE_DEF( N_("Julia Fractal"),  TV_OBJ3D_JULIA, "object_default.xpm", N_("A julia fractal.") ),	
	OBJ3D_INLINE_DEF( N_("Lathe"),  TV_OBJ3D_LATHE, "object_lathe.xpm", N_("A lathe.") ),	
	OBJ3D_INLINE_DEF( N_("Prism"),  TV_OBJ3D_PRISM, "object_prism.xpm", N_("A Prism.") ),	
	OBJ3D_INLINE_DEF( N_("Sphere"),  TV_OBJ3D_SPHERE, "object_sphere.xpm", N_("A sphere.") ),	
	OBJ3D_INLINE_DEF( N_("Sphere Sweep"),  TV_OBJ3D_SPHERESWEEP, "object_default.xpm", N_("A sphere sweep.") ),	
	OBJ3D_INLINE_DEF( N_("Torus"),  TV_OBJ3D_TORUS, "object_torus.xpm", N_("A torus.") ),
	OBJ3D_INLINE_DEF( N_("Superquadric Ellipsoid"),  TV_OBJ3D_SUPERELLIPSOID, "object_superellipsoid.xpm", N_("A superellipsoid.") ),	
	OBJ3D_INLINE_DEF( N_("Text"),  TV_OBJ3D_TEXT, "object_text.xpm", N_("Text.") ),
	OBJ3D_INLINE_DEF( N_("Torus"),  TV_OBJ3D_TORUS, "object_torus.xpm", N_("A torus.") ),
	};

const int FPP_tree_num = 2;
static Object3DDef FPP_tree[FPP_tree_num] = {
	OBJ3D_INLINE_DEF( N_("Disc"),  TV_OBJ3D_DISC, "object_disc.xpm", N_("A disc.") ),
	OBJ3D_INLINE_DEF( N_("Bicubic Patch"),  TV_OBJ3D_BICUBIC, "object_default.xpm", N_("A Bicubic Patch.") ),
};


// Infinite Solid Primitives
const int ISP_tree_num = 1;
static Object3DDef ISP_tree[ISP_tree_num] = {
	OBJ3D_INLINE_DEF( N_("Plane"),  TV_OBJ3D_PLANE, "object_plane.xpm", N_("A plane.") ),
			
	};

// Atmospherics
const int Atmos_tree_num = 4;
static Object3DDef Atmos_tree[Atmos_tree_num] = {
	OBJ3D_INLINE_DEF( N_("Background"),  TV_OBJ3D_BKGD, "object_bkgd.xpm", N_("Background color definition.") ),
	OBJ3D_INLINE_DEF( N_("Sky sphere"),  TV_OBJ3D_SKY, NULL, N_("Sky definition.") ),
	OBJ3D_INLINE_DEF( "Fog",  TV_OBJ3D_FOG, "object_fog.xpm", "Fog simulation." ),
//	OBJ3D_INLINE_DEF( "Rainbow",  TV_OBJ3D_BOX, NULL, "Rainbow." ),
	OBJ3D_INLINE_DEF( N_("Atmospheric Media"),  TV_OBJ3D_AMEDIA, NULL, N_("Atmospheric media.") ),
	};

// CSG Operators
const int CSG_tree_num = 4;
static Object3DDef CSG_tree[CSG_tree_num] = {
	OBJ3D_INLINE_DEF( N_("Union"),  TV_OBJ3D_CSGUNION, "object_union.xpm", N_("Object union.") ),
	OBJ3D_INLINE_DEF( N_("Merge"),  TV_OBJ3D_CSGMERGE, "object_merge.xpm", N_("Object merge.") ),
	OBJ3D_INLINE_DEF( N_("Intersection"),  TV_OBJ3D_CSGINTERSECTION, "object_inter.xpm", N_("Object intersection.") ),
	OBJ3D_INLINE_DEF( N_("Difference"),  TV_OBJ3D_CSGDIFFERENCE, "object_diff.xpm", N_("Object difference.") ),
	};
	
// Misc objects
const int Misc_tree_num = 6;
static Object3DDef Misc_tree[Misc_tree_num] = {
	OBJ3D_INLINE_DEF( N_("Group"),  TV_OBJ3D_GROUP, "object_default.xpm", N_("Group of objects.") ),
	OBJ3D_INLINE_DEF( N_("IsoSurface"),  TV_OBJ3D_ISOSURFACE, "object_default.xpm", N_("Mathematically defined surface.") ),
	OBJ3D_INLINE_DEF( N_("Parametric"),  TV_OBJ3D_PARAMETRIC, "object_default.xpm", N_("Mathematically defined surface.") ),
	OBJ3D_INLINE_DEF( N_("Link"),  TV_OBJ3D_LINK, "object_link.xpm", N_("Object link.") ),
	OBJ3D_INLINE_DEF( N_("Light Group"),  TV_OBJ3D_LIGHTGROUP, "object_light.xpm", N_("A light group.") ),
	OBJ3D_INLINE_DEF( N_("PovScript"),  TV_OBJ3D_POVSCRIPT, "object_default.xpm", N_("Povray raw script.") ),
	};
#endif
