//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// objectlayer.h
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2005 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */
//*******************************************************************************************
#ifndef TV_OBJLAYER_H
#define TV_OBJLAYER_H
using namespace std;
#include "object3d.h"
#include "material.h"
#include <vector>

//**************************************
// Layer
//**************************************
class ObjectLayer {
	#define SENDER ((ObjectLayer*)data)
	friend void sign_objlayer_edit_clicked( GtkWidget *wid, gint button, gpointer data ) { SENDER->destroy_edit_box(button); }
	friend void sign_objlayer_edit_ok_clicked( GtkWidget *wid, gpointer data ) { SENDER->destroy_edit_box(GTK_RESPONSE_OK); }
	friend void sign_objlayer_edit_box_destroy( GtkWidget *wid, GdkEvent *ev, gpointer data ) { SENDER->destroy_edit_box(-1); }		
	#undef SENDER


	private:
		vector<Object3D*> objects;
			
		TvWidget_bool *visible;
		TvWidget_bool *selectable;		
		TvWidget_bool *render;
		static	app_objs * app_ref;
		TvWidget_entry *name;
		GtkWidget *edit_box, *edit_name_entry;
		static GtkListStore *list_store;
		GtkTreeIter node_iter;
		static GtkWidget *obj_tree_view;
		static GtkTreeStore *obj_tree_store;
		static GtkTreeSelection *obj_tree_selection;

	public:
		ObjectLayer( app_objs *appref );
		ObjectLayer( ObjectLayer & ref );
		~ObjectLayer();

		void set_name( char *nom );
		char* get_name() { return name->value(); }
		void add_to_list( GtkListStore *store, int position = -1 );
		void move_after_in_list( GtkTreeIter *sibling );
		void move_before_in_list( GtkTreeIter *sibling  );
		GtkTreeIter* get_node_iter() { return &node_iter; }
		void remove_from_layer_list() { gtk_list_store_remove( list_store, &node_iter ); }
		void output_to_povray_pass1( ofstream & file );
		void output_to_povray_pass2( ofstream & file );
		void save( ofstream & file );
		bool load( ifstream & file, char *tag );
		void get_materials( vector<Material*> & mlist ) { for ( unsigned int i = 0 ; i < objects.size() ; i ++ ) objects[i]->get_materials( mlist ); }
		
		void display_content( GtkWidget *view, GtkTreeStore *store, GtkTreeSelection *selection );
		void save_tree()  { for ( unsigned int i = 0 ; i < objects.size() ; i ++ ) objects[i]->save_tree(); }
		void add_object( Object3D *obj,  Object3D *selected );
		void delete_object( Object3D *obj );
		void remove_object( Object3D *obj );
		void paste_object( Object3D *obj, Object3D *selected );
		void duplicate_object( Object3D *obj );
		void move_object_up( Object3D *obj );
		void move_object_down( Object3D *obj );
		void unparent_object( Object3D *obj );
		int get_object_pos( Object3D *obj ) { unsigned int i; for ( i = 0 ; i < objects.size() ; i++ ) if ( objects[i] == obj ) break; return i; }
		void insert_object( Object3D *obj, int position );
		void append_object( Object3D *obj ) { add_object( obj, NULL ); /*obj->add_to_tree( obj_ctree, NULL, NULL );*/ }
		void display( glview *view );
		void toggle_property( int col );
		bool test_name( char *nom ) { return strcmp( name->value(), nom ); }
		Object3D *get_first_object() { return ( objects.size() > 0 ) ? objects[0] : NULL; }
		bool can_be_destroyed();
		
		void raise_edit_box();
		void destroy_edit_box( int val );
};


#endif
