//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// plane.h
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2005 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */
//*******************************************************************************************
#ifndef TV_PLANE_H
#define TV_PLANE_H
using namespace std;
#include "object3d.h"

// Dfinition
class Plane : public Object3D_with_material {
	private:
		ObjParam_point *location;
		ObjParam_int *glsize;
		ObjParam_rotation *rotation;

	public:
		Plane( app_objs *appref );
		Plane( Plane & ref );
		~Plane();
		Object3D *duplicate_yourself() { Plane *res = new Plane( *this ); return res; }
		void add_to_tree( GtkWidget *view, GtkTreeStore *store, GtkTreeSelection *sel, GtkTreeIter *parent, GtkTreeIter *sibling, const gchar *pixmap = NULL ) { Object3D::add_to_tree( view, store, sel, parent, sibling, "object_plane.xpm" ); }

		void display( glview *view, bool set_color = true );
		void edit_widget( GtkWidget *wid );
		void destroy_editor();
		void pref_changed();
		
		void mouse_drag( struct drag_info *drag );
		float *get_location() { return location->get(); }
		Rotation *get_rotation() { return rotation->get_rotation(); }
		
		void output_to_povray_pass1( ofstream & file );
		void save( ofstream & file );
		bool load( ifstream & file, char *tag );

				// Access methods
		virtual void set_location(float *data) { location->set(data[0], data[1], data[2]); }
		void set_rotation(float *data) {rotation->set(data[0], data[1], data[2]); rotation->update_widget(); rotation->flush();}
		float* get_rot(float* val) { float _x, _y, _z; rotation->get(_x, _y, _z); val[0] = _x; val[1] = _y; val[2] = _z; return (float*)val;}
};
#endif
