//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// povpreview.h
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2005 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 
//*******************************************************************************************
#ifndef TV_MATPREV_H
#define TV_MATPREV_H
using namespace std;
#include "main.h"
#include "tvwidgets.h"
#include <pthread.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include "material.h"
#include <vector>

#define MATPREV_DEF MaterialPreview *povfe = (MaterialPreview*)(app_ref->povfe);


//**********************************************
//  Front end Class
//
// Define pov front end for scene render
//**********************************************
class MaterialPreview {
	// Callbacks
	#define SENDER ((MaterialPreview*)data)
	friend void *reading_image_thread( void * data ) { SENDER->read_output(); return NULL; }
	friend void *reading_console_thread( void * data ) { SENDER->read_console(); return NULL; }
	friend void sign_matpreview_start_clicked( GtkWidget *wid, gpointer data ) { SENDER->start_clicked(); }
	#undef SENDER

	private:
		app_objs *app_ref;
	
		// Widgets for preview
		GtkWidget *widget, *preview_widget;
		GtkWidget *start_button, *start_label;
		GtkWidget *progress_bar;
	
		// Multithread & process control parameters
		pid_t povray_pid;
		pthread_t output_thread;
		pthread_t console_thread;
		char *pipe_console_name, *pipe_output_name;
		int pipe_console_id, pipe_output_id;

		// Control parameters
		Material *current_material;
		bool render_status;
		bool render_finished;
		bool modal;
		char *scene_file;

		// image buffer
		int image_size;
		char *image;

		// Rendering options	
		TvWidget_int *width, *height;
		TvWidget_bool *antialias;

		// Predefined scenes
		TvWidget_option_combo *predef_scene;
		TvWidget_bool *render_wall;
		TvWidget_bool *render_floor;
		TvWidget_option_combo *predef_sizes;
		TvWidget_bool *render_sky;
		
		char *get_scene_file( Material *mat );
		void flush();

		// Process control
		bool render_preview( char *source_file );
		void stop_render_preview();
		void stop_preview( bool close_console );
		void start_clicked();
		
		// Pipe data analysis
		bool get_pipe_line( int file, char *buffer, int size );
		void read_output();
		void read_console();
		
	public:
		MaterialPreview( app_objs *app_ref );
		~MaterialPreview();

		// Options
		void set_size( int w, int h ) { width->set(w); height->set(h); }
		void set_current_material( Material *mat ) { current_material = mat; }

		// Widget
		void get_widget( GtkWidget *box, bool tt, bool for_save_dialog = false );

		// Process control
		bool start_preview( Material *mat , bool save, bool modal );
		bool start_preview_current( bool save, bool modal ) { return start_preview( current_material, save, modal ); }
		void cancel_preview() ;
		
		// Save preview as thumbnail
		void save_as_preview( ofstream & file );
		void save_preview_settings();
};

#endif
