//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// povscript.h
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2005 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 
//*******************************************************************************************
#ifndef TV_POVSCRIPT_H
#define TV_POVSCRIPT_H
using namespace std;
#include "object3d.h"

// Definition
// Povray raw Script
class PovScript : public Object3D_with_material {
	private:
		TvWidget_TextButton *script;
	
	public:
		PovScript( app_objs *appref );
		PovScript( PovScript & ref );
		~PovScript();
		Object3D *duplicate_yourself() { PovScript *res = new PovScript( *this ); return res; }

		void edit_widget( GtkWidget *wid );
		void destroy_editor();
		void pref_changed();
		
		void output_to_povray_pass1( ofstream & file );
		void output_to_povray_pass2( ofstream & file );
		void save( ofstream & file );
		bool load( ifstream & file, char *tag );
};
#endif
