//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// preferences.h
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2001 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 
//*******************************************************************************************
#ifndef PREFERENCES_H
#define PREFERENCES_H
using namespace std;
#include <vector>
#include "main.h"
#include "tvwidgets.h"

#define PREF_DEF Preferences *pref = (Preferences*)(app_ref->prefer);


//***********************************************
// Objet prfrences
//***********************************************
class Preferences : private app_object {
	// Callbacks
	#define SENDER ((Preferences*)data)
	friend gint pref_dlg( GtkWidget *wid, gpointer data ) { SENDER->raise_dlg(); return -1; }
	friend gint dlg_click( GtkDialog *wid, gint button, gpointer data ) { SENDER->clicked(button); return -1; }
	friend gint dlg_destroy( GtkWidget *wid, GdkEvent *ev, gpointer data ) { SENDER->clicked(-1); return 0; }	
	#undef SENDER

	private:
		app_objs * app_ref;
		bool changed, applied;
		vector<TvWidget *> PrefList;
		GtkWidget *dialog, *notebk;
		int selected_page;
		char *home;
		char *pref_file;

		// fonctions boite de prfrences
		void clicked( gint button );
		void close_dlg();
		void flush_dlg() { for ( register unsigned int i = 0 ; i < PrefList.size()  ; i++ ) PrefList[i]->flush(); }
		void undo_dlg() { for ( register unsigned int i = 0 ; i < PrefList.size()  ; i++ ) PrefList[i]->restore(); }
		void pref_changed() { for ( register unsigned int i = 0 ; i < PrefList.size()  ; i++ ) PrefList[i]->pref_changed(); }
		void send_message();

		
	// Section window
	public:
		TvWidget_bool *save_geo, *tooltips, *toolbar, *toolbar_text;
		TvWidget_bool *save_dlg_geo;
		TvWidget_int *win_xpos, *win_ypos, *win_xsize, *win_ysize;
		TvWidget_int *med_xpos, *med_ypos, *med_xsize, *med_ysize;
		TvWidget_int *con_xpos, *con_ypos, *con_xsize, *con_ysize;
		TvWidget_int *ropt_xpos, *ropt_ypos, *ropt_xsize, *ropt_ysize;
		TvWidget_int *mlib_xpos, *mlib_ypos, *mlib_xsize, *mlib_ysize;
		TvWidget_int *rdlg_xpos, *rdlg_ypos;
		TvWidget_color *tbar_selected, *tbar_unselected;
		TvWidget_bool *matedit;
		TvWidget_int *undo_limit;
		TvWidget_int *pan_pos;
		TvWidget_bool *pan_hidden;
		TvWidget_StringList *recent_files;
		TvWidget_bool *display_splash, *no_script_exec;
		TvWidget_bool *auto_obj_edit;

	// Section view
		// Axis & Grid
		TvWidget_color *axis_color;
		TvWidget_bool *axis2D, *axis3D, *labels3D, *labels2D;
		TvWidget_color *labels_color;
		TvWidget_bool *gridxy, *gridxz, *gridyz, *grid2D;
		TvWidget_color *gridxy_color, *gridxz_color,*gridyz_color;
		
		TvWidget_int *view_modes[4];
		TvWidget_bool *line_antialias, *zoom2d, *nav2D;		
		TvWidget_color *v3dbkg_color, *v2dbkg_color;
		TvWidget_color *obj_color, *objsel_color;
		TvWidget_option_combo *blob_preview_quality;
		TvWidget_option_combo *preview_quality;
		TvWidget_int *hf_preview_quality;
		
		// Grid and Snapping
		TvWidget_float *grid_spacing;
        TvWidget_int *grid_major_lines;

		// Paths
		TvWidget_path *povcmd;
		TvWidget_path *fonts_path;
		TvWidget_float *gamma;
		TvWidget_entry *author;
		
	// Material preview
		TvWidget_bool *save_preview_settings;
		TvWidget_int *preview_size, *preview_object;
		TvWidget_bool *preview_wall, *preview_floor, *preview_sky, *preview_antialias;
		
	// Prop Panel
		TvWidget_bool *edit_page_detached;
		TvWidget_bool *select_page_detached;
		TvWidget_bool *create_page_detached;
		TvWidget_bool *material_page_detached;
		TvWidget_int *ppep_xpos, *ppep_ypos, *ppep_xsize, *ppep_ysize;
		TvWidget_int *ppsp_xpos, *ppsp_ypos, *ppsp_xsize, *ppsp_ysize;
		TvWidget_int *ppcp_xpos, *ppcp_ypos, *ppcp_xsize, *ppcp_ysize;
		TvWidget_int *ppmp_xpos, *ppmp_ypos, *ppmp_xsize, *ppmp_ysize;
		

	public:
		Preferences( app_objs * app_ref );
		~Preferences() { delete home; delete pref_file; }
		void raise_dlg();
		void save();
		void 		load();
		char *get_home_dir() { return home; }
};

#endif
