//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// proppanel.h
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2001 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 
//*******************************************************************************************
#ifndef PROPPANEL_H
#define PROPPANEL_H
using namespace std;
#include "main.h"

#define PROPPANEL_DEF PropPanel *proppanel = (PropPanel*)(app_ref->proppanel);
#define PROPPANEL_MAX_PAGE 5

class PropPanel : public app_object {
#define SENDER ((PropPanel*)data)
	friend void sign_proppanel_clicked( GtkWidget *wid, gpointer data ) { SENDER->label_clicked( wid ); }
	friend void sign_proppanel_detach( GtkWidget *wid, gpointer data ) { SENDER->detach( wid ); }
	friend bool sign_proppanel_attach( GtkWidget *wid, GdkEvent *event, gpointer data ) { return FALSE; /*SENDER->attach( wid );*/ }
	friend void sign_proppanel_attach2( GtkWidget *wid, gpointer data ) { SENDER->attach( wid ); }
#undef SENDER


	private:
		app_objs * app_ref;
		GtkWidget *notebook;
		GtkWidget *label_button[PROPPANEL_MAX_PAGE];
		GtkTooltips *proppanel_tooltips[PROPPANEL_MAX_PAGE];
		bool pages_detach_state[PROPPANEL_MAX_PAGE];
		GtkWidget *page_containers[PROPPANEL_MAX_PAGE];
		GtkWidget *detach_buttons[PROPPANEL_MAX_PAGE];
		GtkWidget *pages_window[PROPPANEL_MAX_PAGE];
	
		GtkWidget *create_notebook_page(  int page_num );
		void label_clicked( GtkWidget *wid );	
		void detach( GtkWidget *wid );
		void attach( GtkWidget *wid );
		
		
	public:
		PropPanel( app_objs* appref, GtkWidget *box );
		~PropPanel();
		void set_page( gint num ) { gtk_notebook_set_page( GTK_NOTEBOOK(notebook), num ); }
		
		void pref_changed();
};

#endif
