//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// pyengine.h
//
// Christian Spoer <spoer@users.sourceforge.net>
// Copyright (C) 2000-2005 Christian Spoer
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */
//*******************************************************************************************
#ifndef TV_PYENGINE_H
#define TV_PYENGINE_H

using namespace std;

extern "C" {
#include "Python.h"
}
#include "main.h"

#define ENGINE_DEF PyEngine *engine = (PyEngine*)(app_ref->python_engine);

const int PY_MODE_REGISTER = 0;
const int PY_MODE_CREATE = 1;
const int PY_MODE_EDIT = 2;
const int PY_MODE_POVPASS1 = 3;
const int PY_MODE_POVPASS2 = 4;

//**********************************************
// Classe scene
//**********************************************
class PyEngine : public app_object {
	// Callbacks
#define SENDER ((PyEngine*)data)
	friend void sign_execute_script( GtkWidget *wid, gpointer data ) {  SENDER->load_as(); }
#undef SENDER
	
 private:
	app_objs *app_ref;
	GtkWidget *filebox;
	char *filename;
	char *default_path;
	PyObject* my_module;
 public:
	PyEngine( app_objs *app_ref );
	~PyEngine();
	int initialize();
	int initialize(char* fname, PyObject *obj, int _mode);
	void execute_script();
	void execute_script(char* fname, PyObject* obj, int _mode);
	void load_with_fbox();
	void load_as();
	
};

#endif // TV_PYENGINE_H
