//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// pylights.h
//
// Christian Spoer <spoer@users.sourceforge.net>
// Copyright (C) 2000-2005 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 
//*******************************************************************************************
#ifndef TV_PYLIGHTS_H
#define TV_PYLIGHTS_H

using namespace std;

#include "Python.h"
#include "object3d.h"
#include "lights.h"

class PyPointLight
{
 public:
	static PyMethodDef python_methods[];
	static PyObject* new_pointlight(PyObject* self, PyObject* args);

	static PyObject* get_location(PyObject* self, PyObject* args);
	static PyObject* set_location(PyObject* self, PyObject* args);

	static PyObject* is_media_attenuation(PyObject* self, PyObject* args);
	static PyObject* set_media_attenuation(PyObject* self, PyObject* args);
	
	static PyObject* is_media_interaction(PyObject* self, PyObject* args);
	static PyObject* set_media_interaction(PyObject* self, PyObject* args);
	
	static PyObject* is_parallel(PyObject* self, PyObject* args);
	static PyObject* set_parallel(PyObject* self, PyObject* args);
	
	static PyObject* is_refraction(PyObject* self, PyObject* args);
	static PyObject* set_refraction(PyObject* self, PyObject* args);
	
	static PyObject* is_reflection(PyObject* self, PyObject* args);
	static PyObject* set_reflection(PyObject* self, PyObject* args);
	
	static PyObject* is_fade(PyObject* self, PyObject* args);
	static PyObject* set_fade(PyObject* self, PyObject* args);
	
	static PyObject* is_area(PyObject* self, PyObject* args);
	static PyObject* set_area(PyObject* self, PyObject* args);

	static PyObject* get_color(PyObject* self, PyObject* args);
	static PyObject* set_color(PyObject* self, PyObject* args);
	
	static PyObject* get_fade_distance(PyObject* self, PyObject* args);
	static PyObject* set_fade_distance(PyObject* self, PyObject* args);
	
	static PyObject* get_fade_power(PyObject* self, PyObject* args);
	static PyObject* set_fade_power(PyObject* self, PyObject* args);
};

class PyAreaLight
{
 public:
	static PyMethodDef python_methods[];
	static PyObject* new_arealight(PyObject* self, PyObject* args);

	static PyObject* get_rotation(PyObject* self, PyObject* args);
	static PyObject* set_rotation(PyObject* self, PyObject* args);

	static PyObject* get_size(PyObject* self, PyObject* args);
	static PyObject* set_size(PyObject* self, PyObject* args);

	static PyObject* get_size_z(PyObject* self, PyObject* args);
	static PyObject* set_size_z(PyObject* self, PyObject* args);

	static PyObject* get_size_x(PyObject* self, PyObject* args);
	static PyObject* set_size_x(PyObject* self, PyObject* args);

	static PyObject* get_adaptive(PyObject* self, PyObject* args);
	static PyObject* set_adaptive(PyObject* self, PyObject* args);

	static PyObject* is_jitter(PyObject* self, PyObject* args);
	static PyObject* set_jitter(PyObject* self, PyObject* args);
	
	static PyObject* is_circular(PyObject* self, PyObject* args);
	static PyObject* set_circular(PyObject* self, PyObject* args);
	
	static PyObject* is_parallel(PyObject* self, PyObject* args);
	static PyObject* set_parallel(PyObject* self, PyObject* args);
	
	static PyObject* is_orient(PyObject* self, PyObject* args);
	static PyObject* set_orient(PyObject* self, PyObject* args);
};

class PySpotLight
{
 public:
	static PyMethodDef python_methods[];
	static PyObject* new_spotlight(PyObject* self, PyObject* args);

	static PyObject* get_location(PyObject* self, PyObject* args);
	static PyObject* set_location(PyObject* self, PyObject* args);

	static PyObject* is_media_attenuation(PyObject* self, PyObject* args);
	static PyObject* set_media_attenuation(PyObject* self, PyObject* args);
	
	static PyObject* is_media_interaction(PyObject* self, PyObject* args);
	static PyObject* set_media_interaction(PyObject* self, PyObject* args);
	
	static PyObject* is_parallel(PyObject* self, PyObject* args);
	static PyObject* set_parallel(PyObject* self, PyObject* args);
	
	static PyObject* is_refraction(PyObject* self, PyObject* args);
	static PyObject* set_refraction(PyObject* self, PyObject* args);
	
	static PyObject* is_reflection(PyObject* self, PyObject* args);
	static PyObject* set_reflection(PyObject* self, PyObject* args);
	
	static PyObject* is_fade(PyObject* self, PyObject* args);
	static PyObject* set_fade(PyObject* self, PyObject* args);
	
	static PyObject* is_area(PyObject* self, PyObject* args);
	static PyObject* set_area(PyObject* self, PyObject* args);

	static PyObject* get_color(PyObject* self, PyObject* args);
	static PyObject* set_color(PyObject* self, PyObject* args);
	
	static PyObject* get_fade_distance(PyObject* self, PyObject* args);
	static PyObject* set_fade_distance(PyObject* self, PyObject* args);
	
	static PyObject* get_fade_power(PyObject* self, PyObject* args);
	static PyObject* set_fade_power(PyObject* self, PyObject* args);

	static PyObject* get_tightness(PyObject* self, PyObject* args);
	static PyObject* set_tightness(PyObject* self, PyObject* args);

	static PyObject* get_point_at(PyObject* self, PyObject* args);
	static PyObject* set_point_at(PyObject* self, PyObject* args);

	static PyObject* is_show_frustum(PyObject* self, PyObject* args);
	static PyObject* set_show_frustum(PyObject* self, PyObject* args);

	static PyObject* get_radius(PyObject* self, PyObject* args);
	static PyObject* set_radius(PyObject* self, PyObject* args);

	static PyObject* get_falloff(PyObject* self, PyObject* args);
	static PyObject* set_falloff(PyObject* self, PyObject* args);
};

class PyCylindricalLight
{
 public:
	static PyMethodDef python_methods[];
	static PyObject* new_cylindricallight(PyObject* self, PyObject* args);
};
#endif // TV_PYLIGHTS_H
