//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// pyobjects.h
//
// Christian Spoer <spoer@users.sourceforge.net>
// Copyright (C) 2000-2005 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */
//*******************************************************************************************
#ifndef TV_PYOBJECTS_H
#define TV_PYOBJECTS_H

using namespace std;

#include "Python.h"
#include "object3d.h"
#include "scene.h"
#include "main.h"
#include "box.h"
#include "sphere.h"
#include "cone.h"
#include "plane.h"
#include "superellipsoid.h"
#include "obj3dcsg.h"
#include "torus.h"
#include "cylinder.h"
#include "disc.h"
#include "bicubic.h"

class PyApp
{
 public:
	static PyMethodDef python_methods[];
	static PyObject* exit_app( PyObject* self, PyObject* args );
	static PyObject* load( PyObject* self, PyObject* args );
	static PyObject* save( PyObject* self, PyObject* args );
	static PyObject* warning_msg( PyObject* self, PyObject* args );
	static PyObject* register_script( PyObject* self, PyObject* args );
};

class PyLayer
{
 public:
	static PyMethodDef python_methods[];
	static PyObject* new_layer(PyObject* self, PyObject* args);
	static PyObject* add_object(PyObject* self, PyObject* args1);
	static PyObject* set_name(PyObject* self, PyObject* args);
	static PyObject* get_name(PyObject* self, PyObject* args);
};

class PyScene
{
 public:
	static PyMethodDef python_methods[];
	static PyObject* add_layer(PyObject* self, PyObject* args);
	static PyObject* add_object(PyObject* self, PyObject* args);
};


class PyObject3D
{
 public:
	static PyMethodDef python_methods[];
	static PyObject* set_name(PyObject* self, PyObject* args);
	static PyObject* get_name(PyObject* self, PyObject* args);

	static PyObject* set_render(PyObject* self, PyObject* args);
	static PyObject* set_hidden(PyObject* self, PyObject* args);
	static PyObject* set_no_shadow(PyObject* self, PyObject* args);
	static PyObject* set_hollow(PyObject* self, PyObject* args);
	static PyObject* set_inverse(PyObject* self, PyObject* args);
	static PyObject* set_no_image(PyObject* self, PyObject* args);
	static PyObject* set_no_reflection(PyObject* self, PyObject* args);
	static PyObject* set_double_illuminate(PyObject* self, PyObject* args);
	static PyObject* select(PyObject* self, PyObject* args);
	static PyObject* unselect(PyObject* self, PyObject* args);

	static PyObject* is_render(PyObject* self, PyObject* args);
	static PyObject* is_hidden(PyObject* self, PyObject* args);
	static PyObject* is_no_shadow(PyObject* self, PyObject* args);
	static PyObject* is_hollow(PyObject* self, PyObject* args);
	static PyObject* is_inverse(PyObject* self, PyObject* args);
	static PyObject* is_no_image(PyObject* self, PyObject* args);
	static PyObject* is_no_reflection(PyObject* self, PyObject* args);
	static PyObject* is_double_illuminate(PyObject* self, PyObject* args);
	static PyObject* is_selected(PyObject* self, PyObject* args);
	

	static PyObject* set_parent(PyObject* self, PyObject* args);
	static PyObject* get_parent(PyObject* self, PyObject* args);
	static PyObject* set_layer(PyObject* self, PyObject* args);
	static PyObject* get_layer(PyObject* self, PyObject* args);
	static PyObject* set_type(PyObject* self, PyObject* args);
	static PyObject* get_type(PyObject* self, PyObject* args);
	static PyObject* set_category(PyObject* self, PyObject* args);
	static PyObject* get_category(PyObject* self, PyObject* args);	
};

class PyObject3DMaterial
{
 public:
	static PyMethodDef python_methods[];
	static PyObject* is_target(PyObject* self, PyObject* args);
	static PyObject* is_refraction(PyObject* self, PyObject* args);
	static PyObject* is_reflection(PyObject* self, PyObject* args);
	static PyObject* is_collect(PyObject* self, PyObject* args);
	static PyObject* is_pass_through(PyObject* self, PyObject* args);
	static PyObject* get_spacing(PyObject* self, PyObject* args);
	static PyObject* set_target(PyObject* self, PyObject* args);
	static PyObject* set_refraction(PyObject* self, PyObject* args);
	static PyObject* set_reflection(PyObject* self, PyObject* args);
	static PyObject* set_collect(PyObject* self, PyObject* args);
	static PyObject* set_pass_through(PyObject* self, PyObject* args);
	static PyObject* set_spacing(PyObject* self, PyObject* args);
};

class PyBox
{
 public:
	static PyMethodDef python_methods[];
	static PyObject* new_box(PyObject* self, PyObject* args);
	static PyObject* access_box(PyObject* self, PyObject* args);

	static PyObject* get_location(PyObject* self, PyObject* args);
	static PyObject* set_location(PyObject* self, PyObject* args);

	static PyObject* get_size(PyObject* self, PyObject* args);
	static PyObject* set_size(PyObject* self, PyObject* args);

	static PyObject* get_rotation(PyObject* self, PyObject* args);
	static PyObject* set_rotation(PyObject* self, PyObject* args);

	static PyObject* get_corner1(PyObject* self, PyObject* args);
	static PyObject* set_corner1(PyObject* self, PyObject* args);

	static PyObject* get_corner2(PyObject* self, PyObject* args);
	static PyObject* set_corner2(PyObject* self, PyObject* args);
};

class PySphere
{
 public:
	static PyMethodDef python_methods[];
	static PyObject* new_sphere(PyObject* self, PyObject* args);

	static PyObject* get_location(PyObject* self, PyObject* args);
	static PyObject* set_location(PyObject* self, PyObject* args);

	static PyObject* get_size(PyObject* self, PyObject* args);
	static PyObject* set_size(PyObject* self, PyObject* args);

	static PyObject* get_rotation(PyObject* self, PyObject* args);
	static PyObject* set_rotation(PyObject* self, PyObject* args);

	static PyObject* get_radius(PyObject* self, PyObject* args);
	static PyObject* set_radius(PyObject* self, PyObject* args);
};

class PyCone
{
 public:
	static PyMethodDef python_methods[];
	static PyObject* new_cone(PyObject* self, PyObject* args);

	static PyObject* get_location(PyObject* self, PyObject* args);
	static PyObject* set_location(PyObject* self, PyObject* args);

	static PyObject* get_size(PyObject* self, PyObject* args);
	static PyObject* set_size(PyObject* self, PyObject* args);
	
	static PyObject* get_rotation(PyObject* self, PyObject* args);
	static PyObject* set_rotation(PyObject* self, PyObject* args);

	static PyObject* get_cap_radius(PyObject* self, PyObject* args);
	static PyObject* set_cap_radius(PyObject* self, PyObject* args);

	static PyObject* get_base_radius(PyObject* self, PyObject* args);
	static PyObject* set_base_radius(PyObject* self, PyObject* args);

	static PyObject* get_cap_point(PyObject* self, PyObject* args);
	static PyObject* set_cap_point(PyObject* self, PyObject* args);

	static PyObject* get_base_point(PyObject* self, PyObject* args);
	static PyObject* set_base_point(PyObject* self, PyObject* args);

	static PyObject* is_open(PyObject* self, PyObject* args);
	static PyObject* set_open(PyObject* self, PyObject* args);
};

class PyCylinder
{
 public:
	static PyMethodDef python_methods[];
	static PyObject* new_cylinder(PyObject* self, PyObject* args);

	static PyObject* get_location(PyObject* self, PyObject* args);
	static PyObject* set_location(PyObject* self, PyObject* args);

	static PyObject* get_size(PyObject* self, PyObject* args);
	static PyObject* set_size(PyObject* self, PyObject* args);
	
	static PyObject* get_rotation(PyObject* self, PyObject* args);
	static PyObject* set_rotation(PyObject* self, PyObject* args);

	static PyObject* get_radius(PyObject* self, PyObject* args);
	static PyObject* set_radius(PyObject* self, PyObject* args);

	static PyObject* get_cap_point(PyObject* self, PyObject* args);
	static PyObject* set_cap_point(PyObject* self, PyObject* args);

	static PyObject* get_base_point(PyObject* self, PyObject* args);
	static PyObject* set_base_point(PyObject* self, PyObject* args);

	static PyObject* is_open(PyObject* self, PyObject* args);
	static PyObject* set_open(PyObject* self, PyObject* args);
};

class PyPlane
{
 public:
	static PyMethodDef python_methods[];
	static PyObject* new_plane(PyObject* self, PyObject* args);

	static PyObject* get_location(PyObject* self, PyObject* args);
	static PyObject* set_location(PyObject* self, PyObject* args);

	static PyObject* get_rotation(PyObject* self, PyObject* args);
	static PyObject* set_rotation(PyObject* self, PyObject* args);
};

class PySuperEllipsoid
{
 public:
	static PyMethodDef python_methods[];
	static PyObject* new_superellipsoid(PyObject* self, PyObject* args);

	static PyObject* get_location(PyObject* self, PyObject* args);
	static PyObject* set_location(PyObject* self, PyObject* args);

	static PyObject* get_rotation(PyObject* self, PyObject* args);
	static PyObject* set_rotation(PyObject* self, PyObject* args);

	static PyObject* get_size(PyObject* self, PyObject* args);
	static PyObject* set_size(PyObject* self, PyObject* args);

	static PyObject* set_east(PyObject* self, PyObject* args);
	static PyObject* set_north(PyObject* self, PyObject* args);

	static PyObject* get_east(PyObject* self, PyObject* args);
	static PyObject* get_north(PyObject* self, PyObject* args);
};

class PyCSGObject
{
 public:
	static PyMethodDef python_methods[];
	//static PyObject* new_csgobject(PyObject* self, PyObject* args);

	static PyObject* get_location(PyObject* self, PyObject* args);
	static PyObject* set_location(PyObject* self, PyObject* args);

	static PyObject* get_rotation(PyObject* self, PyObject* args);
	static PyObject* set_rotation(PyObject* self, PyObject* args);

	static PyObject* get_size(PyObject* self, PyObject* args);
	static PyObject* set_size(PyObject* self, PyObject* args);

	static PyObject* is_evaluate(PyObject* self, PyObject* args);
	static PyObject* set_evaluate(PyObject* self, PyObject* args);

	static PyObject* add_object(PyObject* self, PyObject* args);
};

class PyCSGCutAway
{
 public:
	static PyMethodDef python_methods[];
	static PyObject* is_cutaway_textures(PyObject* self, PyObject* args);
	static PyObject* set_cutaway_textures(PyObject* self, PyObject* args);
};

class PyCSGUnion
{
 public:
	static PyMethodDef python_methods[];
	static PyObject* new_csgunion(PyObject* self, PyObject* args);	
};	

class PyCSGDifference
{
 public:
	static PyMethodDef python_methods[];
	static PyObject* new_csgdifference(PyObject* self, PyObject* args);	
};

class PyCSGMerge
{
 public:
	static PyMethodDef python_methods[];
	static PyObject* new_csgmerge(PyObject* self, PyObject* args);	
};


class PyCSGIntersection
{
 public:
	static PyMethodDef python_methods[];
	static PyObject* new_csgintersection(PyObject* self, PyObject* args);	
};

class PyTorus
{
 public:
	static PyMethodDef python_methods[];
	static PyObject* new_torus(PyObject* self, PyObject* args);

	static PyObject* get_location(PyObject* self, PyObject* args);
	static PyObject* set_location(PyObject* self, PyObject* args);

	static PyObject* get_size(PyObject* self, PyObject* args);
	static PyObject* set_size(PyObject* self, PyObject* args);
	
	static PyObject* get_rotation(PyObject* self, PyObject* args);
	static PyObject* set_rotation(PyObject* self, PyObject* args);

	static PyObject* get_minor_radius(PyObject* self, PyObject* args);
	static PyObject* set_minor_radius(PyObject* self, PyObject* args);

	static PyObject* get_major_radius(PyObject* self, PyObject* args);
	static PyObject* set_major_radius(PyObject* self, PyObject* args);

	static PyObject* is_sturm(PyObject* self, PyObject* args);
	static PyObject* set_sturm(PyObject* self, PyObject* args);
};

class PyDisc
{
 public:
	static PyMethodDef python_methods[];
	static PyObject* new_disc(PyObject* self, PyObject* args);

	static PyObject* get_location(PyObject* self, PyObject* args);
	static PyObject* set_location(PyObject* self, PyObject* args);

	static PyObject* get_size(PyObject* self, PyObject* args);
	static PyObject* set_size(PyObject* self, PyObject* args);
	
	static PyObject* get_rotation(PyObject* self, PyObject* args);
	static PyObject* set_rotation(PyObject* self, PyObject* args);

	static PyObject* get_radius(PyObject* self, PyObject* args);
	static PyObject* set_radius(PyObject* self, PyObject* args);

	static PyObject* get_hole_radius(PyObject* self, PyObject* args);
	static PyObject* set_hole_radius(PyObject* self, PyObject* args);
};

class PyBicubic
{
 public:
	static PyMethodDef python_methods[];
	static PyObject* new_bicubic(PyObject* self, PyObject* args);

	static PyObject* get_location(PyObject* self, PyObject* args);
	static PyObject* set_location(PyObject* self, PyObject* args);

	static PyObject* get_size(PyObject* self, PyObject* args);
	static PyObject* set_size(PyObject* self, PyObject* args);
	
	static PyObject* get_rotation(PyObject* self, PyObject* args);
	static PyObject* set_rotation(PyObject* self, PyObject* args);

	static PyObject* get_ustep(PyObject* self, PyObject* args);
	static PyObject* set_ustep(PyObject* self, PyObject* args);

	static PyObject* get_vstep(PyObject* self, PyObject* args);
	static PyObject* set_vstep(PyObject* self, PyObject* args);

	static PyObject* get_flatness(PyObject* self, PyObject* args);
	static PyObject* set_flatness(PyObject* self, PyObject* args);

	static PyObject* get_control_point(PyObject* self, PyObject* args);
	static PyObject* set_control_point(PyObject* self, PyObject* args);

	static PyObject* is_preprocess(PyObject* self, PyObject* args);
	static PyObject* set_preprocess(PyObject* self, PyObject* args);

	static PyObject* is_edit(PyObject* self, PyObject* args);
	static PyObject* set_edit(PyObject* self, PyObject* args);
};


#endif // TV_PYOBJECTS_H
