#ifndef TV_PYSCRIPTDB_H
#define TV_PYSCRIPTDB_H

#include <vector>
#include <gnome.h>
#include "main.h"
#include "pyengine.h"

using namespace std;

#define PYSCRIPTDB_DEF PyScriptDB *pyscript_db = (PyScriptDB*)(app_ref->pyscript_db);

class PyScript
{
 public:
	PyScript();
	~PyScript();

	void set_script_path(char* sp) { _script_path = sp; }
	char* get_script_path() { return _script_path; }

	void set_description(char* d) { _description = d; }
	char* get_description() { return _description; }

	void set_help_message(char* d) { _help_message = d; }
	char* get_help_message() { return _help_message; }

	void set_author(char* d) { _author = d; }
	char* get_author() { return _author; }

	void set_copyright(char* d) { _copyright = d; }
	char* get_copyright() { return _copyright; }

	void set_year(char* d) { _year = d; }
	char* get_year() { return _year; }

	void set_object_types(char* d) { _object_types = d; }
	char* get_object_types() { return _object_types; }
		
	void set_menupath(char* d) { _menupath = d; }
	char* get_menupath() { return _menupath; }
	vector<char*>*split_menu_path();
	void show_script_info();
	void execute();// { printf("Execute: %s\n", _script_path);fflush(stdout); }
	char* get_top_level_menu() { return _top_level_menu; }

	void set_pyengine( PyEngine* pe ) { _my_pyengine = pe; }
 protected:
	char* _script_path;
	char* _description;
	char* _help_message;
	char* _author;
	char* _copyright;
	char* _year;
	char* _object_types;
	char* _menupath;
	char* _top_level_menu;
	PyEngine* _my_pyengine;
};


class PyScriptDB : public app_object
{
	friend void sign_run_script_from_menu( GtkWidget *wid, gpointer data ) { ((PyScript*)data)->execute(); }
 private:
	vector<PyScript*> *py_script_list;
	app_objs *app_ref;
 public:
	PyScriptDB( app_objs *appref );
	~PyScriptDB();

	void register_script( PyScript *ps );// { py_script_list->push_back( ps ); }
	void pref_changed() {}
	void scan_directory( char* dir );
	void create_menu_structure(GtkUIManager *ui_manager);
};



#endif // TV_PYSCRIPTDB_H
