//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// pyscriptobj.h
//
// Christian Spoer <spoer@users.sourceforge.net>
// Copyright (C) 2000-2005 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 
//*******************************************************************************************
#ifndef TV_PYSCRIPTOBJ_H
#define TV_PYSCRIPTOBJ_H

using namespace std;

#include "Python.h"
#include "object3d.h"
#include "scriptobj.h"

class PyScriptObj
{
 public:
	static PyMethodDef python_methods[];
	static PyObject* new_scriptobject(PyObject* self, PyObject* args);

	static PyObject* get_location(PyObject* self, PyObject* args);
	static PyObject* set_location(PyObject* self, PyObject* args);

	static PyObject* get_rotation(PyObject* self, PyObject* args);
	static PyObject* set_rotation(PyObject* self, PyObject* args);

	static PyObject* get_size(PyObject* self, PyObject* args);
	static PyObject* set_size(PyObject* self, PyObject* args);

	static PyObject* get_script_path(PyObject* self, PyObject* args);
	static PyObject* set_script_path(PyObject* self, PyObject* args);

	static PyObject* new_int(PyObject* self, PyObject* args);
	static PyObject* new_float(PyObject* self, PyObject* args);
	static PyObject* new_double(PyObject* self, PyObject* args);
	static PyObject* new_string(PyObject* self, PyObject* args);

	static PyObject* get_int(PyObject* self, PyObject* args);
	static PyObject* get_float(PyObject* self, PyObject* args);
	static PyObject* get_double(PyObject* self, PyObject* args);
	static PyObject* get_string(PyObject* self, PyObject* args);

	static PyObject* set_int(PyObject* self, PyObject* args);
	static PyObject* set_float(PyObject* self, PyObject* args);
	static PyObject* set_double(PyObject* self, PyObject* args);
	static PyObject* set_string(PyObject* self, PyObject* args);
		
	static PyObject* get_value(PyObject* self, PyObject* args);

	static PyObject* add_triangle(PyObject* self, PyObject* args);
	static PyObject* add_quad(PyObject* self, PyObject* args);

	static PyObject* clear_triangles(PyObject* self, PyObject* args);
	static PyObject* clear_quads(PyObject* self, PyObject* args);

	static PyObject* set_pov_pass1(PyObject* self, PyObject* args);
	static PyObject* set_pov_pass2(PyObject* self, PyObject* args);

	static PyObject* set_has_rotation(PyObject* self, PyObject* args);
	static PyObject* set_has_location(PyObject* self, PyObject* args);
	static PyObject* set_has_scale(PyObject* self, PyObject* args);
	static PyObject* set_has_material(PyObject* self, PyObject* args);
	static PyObject* set_has_editbutton(PyObject* self, PyObject* args);	
};

#endif // TV_PYSCRIPTOBJ_H
