//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// pyoutils.h
//
// Christian Spoer <spoer@users.sourceforge.net>
// Copyright (C) 2000-2005 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */
//*******************************************************************************************
#ifndef TV_PYUTILS_H
#define TV_PYUTILS_H

using namespace std;

#include <Python.h>
#include <string>

/// Common conversions

typedef float* Vector3D;

inline PyObject*
ConvertTuple3(const Vector3D& vec)
{
        // Converts 3d vector to tuple
        return Py_BuildValue("(ddd)", (double)vec[0], (double)vec[1], (double)vec[2]);
}

inline Vector3D
ConvertVector3D(PyObject* Value)
{
        // Converts tuple to 3d vector
        Vector3D result = new float[3];

        if(PyTuple_Check(Value))
        {
                result[0] = (float)PyFloat_AsDouble(PyTuple_GetItem(Value, 0));
                result[1] = (float)PyFloat_AsDouble(PyTuple_GetItem(Value, 1));
                result[2] = (float)PyFloat_AsDouble(PyTuple_GetItem(Value, 2));
        }

        return result;
}

inline void
ConvertVector3DV( PyObject* Value, float *x, float *y, float *z)
{
        // Converts tuple to 3d vector
        if(PyTuple_Check(Value))
        {
                *x = (float)PyFloat_AsDouble(PyTuple_GetItem(Value, 0));
                *y = (float)PyFloat_AsDouble(PyTuple_GetItem(Value, 1));
                *z = (float)PyFloat_AsDouble(PyTuple_GetItem(Value, 2));
        }
}

inline void
ConvertVector3DV_double( PyObject* Value, double *x, double *y, double *z)
{
        // Converts tuple to 3d vector
        if(PyTuple_Check(Value))
        {
                *x = PyFloat_AsDouble(PyTuple_GetItem(Value, 0));
                *y = PyFloat_AsDouble(PyTuple_GetItem(Value, 1));
                *z = PyFloat_AsDouble(PyTuple_GetItem(Value, 2));
        }
}

// From integer to Python integer
inline PyObject*
IntToPyVal(int i)
{
        return Py_BuildValue("i", i);
}

// From long to Python integer
inline PyObject*
LongToPyVal(long l)
{
        return Py_BuildValue("l", l);
}

// From double to Python float
inline PyObject*
DoubleToPyVal(double d)
{
        return Py_BuildValue("d", d);
}

// From std::string to Python string
inline PyObject*
StringToPyVal(std::string s)
{
        return Py_BuildValue("s", (char*)s.c_str());
}

inline PyObject*
StringToPyVal(char* s)
{
        return Py_BuildValue("s", (char*)s);
}

/// Well known Python values
#define PYVAL_NONE             Py_BuildValue("")
#define PYVAL_ZERO             INT_TO_PYVAL(0)
#define PYVAL_ONE              INT_TO_PYVAL(1)
#define PYVAL_FALSE            Py_BuildValue("i", 0)
#define PYVAL_TRUE             Py_BuildValue("i", 1)

#endif // TV_PYUTILS_H
