//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// scene.h
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2005 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */
//*******************************************************************************************
#ifndef TV_SCENE_H
#define TV_SCENE_H
using namespace std;
#include "main.h"
#include "objectlist.h"
#include "matlist.h"

#define SCENE_DEF Scene *scene = (Scene*)(app_ref->scene);

//**********************************************
// Classe scene
//**********************************************
class Scene : public app_object {
	// Callbacks
	#define SENDER ((Scene*)data)
	friend void sign_export_to_povray( GtkWidget *wid, gpointer data ) { SENDER->export_to_povray(); }
	friend void sign_export_scene_pack( GtkWidget *wid, gpointer data ) { SENDER->export_scene_pack(); }	

	friend void sign_scene_save( GtkWidget *wid, gpointer data ) { SENDER->save(); }	
	friend void sign_scene_save_as( GtkWidget *wid, gpointer data ) { SENDER->save_as(); }	

	friend void sign_scene_new( GtkWidget *wid, gpointer data ) { SENDER->new_scene(); }
	
	friend void sign_scene_load( GtkWidget *wid, gpointer data ) { SENDER->load_as(); }	
	#undef SENDER
	
	
	private:
		app_objs *app_ref;
		char *filename;
		char *default_path;
		bool modified;
		bool invalid_font_path;
		ObjectList *objlist;
		MatList *texlist;
		GtkWidget *filebox;
		GtkWidget *tbw_save, *mew_save;
		GtkAction *save_menu_action;
		int load_file_size;
		int save_file_size, save_file_state;

	private:
		void set_filename( const char *filename );
		void store_default_path( char *path );
		void save_widgets_active( gboolean var );
		

	public:
		Scene( app_objs *app_ref );

		void set_win_title();
		void set_modified();
		void set_save_tb_widget( GtkWidget *wid ) { tbw_save = wid; }
		void set_save_menu_widget( GtkWidget *wid ) { mew_save = wid; }
		void set_save_menu_action( GtkAction *action1 ) { save_menu_action = action1; }
		bool is_modified() { return modified; }
		
		void output_to_povray( char *filename, char *ini_name = NULL );
		void export_to_povray();
		char *get_temp_povray_file();

		void export_scene_pack();
		
		void save();
		void save_as();
		void set_save_progress();
		
		void clear_scene();
		void new_scene();
		
		void load( gchar* filename );
		void load_as();
		//void load_with_fbox();
		void set_load_progress( ifstream & file );
		void invalid_font_path_detected() { invalid_font_path = true; }
};

#endif
