//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// slopemap.h
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2001 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */
//*******************************************************************************************
#ifndef TV_SLMAP_H
#define TV_SLMAP_H
using namespace std;
#include "tvwidgets.h"
#include <vector>

class TvWidget_slopemap;

//*******************************************************
// Slope map point
//*******************************************************
class slmap_point {
    friend class TvWidget_slopemap;
	
	private:
		float position;
		float height;
		float slope_up;
		float slope_down;
		
	public:
		slmap_point();
		slmap_point( slmap_point & ref );
				
		void set( float x, float y ) { position = x; height = y; }
		void output_to_povray( ofstream & file );
		void save( ofstream & file );
		void load( ifstream & file );
};




//********************************************************
// Slope map
//********************************************************
#define MAX_SLMAP_BUT 4


class TvWidget_slopemap : public TvWidget {
	#define SENDER ((TvWidget_slopemap*)data)
	friend void sign_slopemap_edit( GtkWidget *wid, gpointer data ) { SENDER->open_editor(); }
	friend gint sign_slopemap_editor_click( GtkWidget *wid, gint button, gpointer data ) { SENDER->editor_clicked(button); return -1; }
	friend gint sign_slopemap_editor_destroy( GtkWidget *wid, GdkEvent *ev, gpointer data ) { SENDER->editor_clicked(-1); return 0; }	
	
	friend void sign_slopecurve_expose( GtkWidget *wid, GdkEventExpose *ev, gpointer data ) { SENDER->expose(ev); }
	friend void sign_slopecurve_configure( GtkWidget *wid, GdkEventConfigure *ev, gpointer data ) { SENDER->configure(); }
	friend void sign_slopecurve_realize( GtkWidget *wid, gpointer data ) { SENDER->realize(); }

	friend void sign_slopecurve_mouse_moved( GtkWidget *wid, GdkEventMotion *ev, gpointer data ) { SENDER->mouse_moved(ev); }	
	friend void sign_slopecurve_mouse_click( GtkWidget *wid, GdkEventButton *ev, gpointer data ) { SENDER->mouse_click(ev); }
	friend void sign_slopecurve_mouse_release( GtkWidget *wid, GdkEventButton *ev, gpointer data ) { SENDER->mouse_release(); }
	
	friend void sign_slmap_button_clicked( GtkWidget *wid, gpointer data ) { SENDER->button_clicked( wid ); }
	friend void sign_slmap_value_changed( GtkWidget *wid, gpointer data ) { SENDER->value_changed(); }
	#undef SENDER
	
	
	private:
		vector<slmap_point*> Points;
		TvWidget_bool_activator *use;
		GtkWidget *activated_box;
		
		GtkWidget *slmap_butt_wid[MAX_SLMAP_BUT];
		GtkTooltips *slmap_butt_tt_wid[MAX_SLMAP_BUT];
		
		GtkWidget *editor;
		int edited;
		bool update;
		GtkWidget *curve;
		GdkPixmap *pix_buffer;
		GtkWidget *point_label;
		GtkWidget *height, *position, *slopeup, *slopedown;
		GtkObject *posadj;
		int drag_type;
		static GdkGC *grid_style;
		
		void button_clicked( GtkWidget *wid );
		void set_edited( int num );
		void value_changed();
		
		void expose( GdkEventExpose *ev );
		void configure();
		void realize();
		void mouse_moved( GdkEventMotion *ev );
		void mouse_click( GdkEventButton *ev );
		void mouse_release();
		void redraw_curve();
	
	public:
		TvWidget_slopemap(  const char *name, const char *sname, const char *tooltip, app_objs *appref );
		TvWidget_slopemap( TvWidget_slopemap & ref );
		virtual TvWidget *duplicate_yourself() { TvWidget_slopemap *res = new TvWidget_slopemap( *this ); return res; }
		virtual ~TvWidget_slopemap();

		void copy( TvWidget *slopemap );
		void get_widget_wnframe( GtkWidget *box, bool tt, bool frame );
		void get_widget( GtkWidget *box, bool tt) { get_widget_wnframe( box, tt, true ); }
		void get_widget_noframe( GtkWidget *box, bool tt ) { get_widget_wnframe( box, tt, false ); }
		void clear_widget();
		void flush();
		void pref_changed();
		void output_to_povray( ofstream & file );
		void save( ofstream & file );
		bool load( ifstream & file, char * tag );
		
		// editor
		void open_editor();
		void close_editor();
		void editor_clicked( int button );

};


class TvWidget_slopemap_rb : public TvWidget_slopemap  {
	protected:
		Rolling_box *rb;

	public:
		TvWidget_slopemap_rb( const char *name, const char *sname, const char *tooltip, app_objs *appref )
			: TvWidget_slopemap( name, sname, tooltip, appref )
			{ rb = new Rolling_box( name, app_ref, (TvWidget*)this ); }
		TvWidget_slopemap_rb( TvWidget_slopemap_rb & ref ) : TvWidget_slopemap( ref ) { rb = new Rolling_box( *(ref.rb) );  rb->set_child( (TvWidget*)this ); }
		virtual TvWidget *duplicate_yourself() { TvWidget_slopemap_rb *res = new TvWidget_slopemap_rb( *this ); return res; }

		void get_widget_rb( GtkWidget *box, bool tt ) { rb->get_widget_rb( box, tt ); }
};

#endif
