//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// spheresweep.h
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2005 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 
//*******************************************************************************************
#ifndef TV_SPHERESWEEP_H
#define TV_SPHERESWEEP_H
using namespace std;
#include "object3d.h"
#include "spline3d.h"


//*******************************************************
// Class sphere sweep
//
// Povray sphere sweep object
//*******************************************************
class SphereSweep : public Object3D_with_material {
	#define SENDER ((SphereSweep*)data)
	friend void sign_ssweep_current_point_num_changed( GtkWidget *wid, gpointer data ) { SENDER->current_point_num_changed(); }
	friend void sign_ssweep_current_point_changed( GtkWidget *wid, gpointer data ) { SENDER->current_point_changed(); }
	friend void sign_ssweep_delete_point( GtkWidget *wid, gpointer data ) { SENDER->delete_point(); }
	friend void sign_ssweep_append_point( GtkWidget *wid, gpointer data ) { SENDER->append_point(); }
	friend void sign_ssweep_prepend_point( GtkWidget *wid, gpointer data ) { SENDER->prepend_point(); }
	friend void sign_ssweep_insert_point( GtkWidget *wid, gpointer data ) { SENDER->insert_point(); }
	#undef SENDER

	private:
		ObjParam_point *location;
		ObjParam_scale *size;
		ObjParam_rotation *rotation;
		Spline3D *spline;
		ObjParam_bool_activator *edit;
		ObjParam_option_combo *spline_type;
		ObjParam_float *tolerance;
	
		GtkWidget *spline_edit_box;
		ObjParam_int *current_point_num;
		ObjParam_point*current_point;
		ObjParam_float *radius;
		bool in_undo;
		bool in_update;
	
		void get_circle_points( float * center, float *direction, float radius, float *xcoords, float *ycoords, float * zcoords, float *xnorm, float *ynorm, float * znorm, int divisions, bool inv_dir = false );

	public:
		SphereSweep( app_objs *appref );
		SphereSweep( SphereSweep & ref );
		~SphereSweep();
		Object3D *duplicate_yourself() { SphereSweep *res = new SphereSweep( *this ); return res; }

		void display( glview *view, bool set_col = true );
		void edit_widget( GtkWidget *wid );
		void destroy_editor();
		void pref_changed();
		
		void mouse_drag( struct drag_info *drag );
		float *get_location() { return location->get(); }
		Rotation *get_rotation() { return rotation->get_rotation(); }
		
		void output_to_povray_pass1( ofstream & file );
		void save( ofstream & file );
		bool load( ifstream & file, char *tag );
		
		void current_point_num_changed();		
		void current_point_changed();
		void delete_point();
		void append_point();
		void prepend_point();
		void insert_point();		
		virtual bool pick_test( int name );
		void undo( Object3D *copy );
		void push_undo_item() { if ( !in_undo && !in_update ) Object3D::push_undo_item(); }
};
#endif
