//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// texfinish.h
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2005 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 
//*******************************************************************************************
#ifndef TEXFINISH_H
#define TEXFINISH_H
using namespace std;
#include "material.h"
#include <vector>

class PovTexFinish : public MaterialItem {
	private:
		vector<TvWidget*> widgets;
		TvWidget_bool_activator *finish;
		TvWidget_color *ambient;
		TvWidget_float *diffuse;
		TvWidget_float *brilliance;
		TvWidget_float *phong;
		TvWidget_int *phong_size;
		TvWidget_float *specular;
		TvWidget_float *roughness;
		TvWidget_float *metalic;
		TvWidget_color *reflection;
		TvWidget_float *reflection_exponent;
		TvWidget_color *reflection_min;
		TvWidget_bool *reflection_fresnel;
		TvWidget_float *reflection_falloff;
		TvWidget_float *reflection_metallic;
		TvWidget_bool_activator *irid;
		TvWidget_float *irid_amount;
		TvWidget_float *irid_thickness;
		TvWidget_float *irid_turbulence;
		TvWidget_bool *conserve_energy;

	public:
		PovTexFinish( app_objs *appref, char *sname );
		PovTexFinish( PovTexFinish & ref );
		virtual ~PovTexFinish();
		virtual MaterialItem *duplicate_yourself() { PovTexFinish *res = new PovTexFinish( *this ); return res; }

		void edit_widget( GtkWidget *box );
		void destroy_widget();
		//virtual void add_to_tree( GtkCTree *tree, GtkCTreeNode *node, GtkCTreeNode *sibling = NULL ) { MaterialItem::add_to_tree( GTK_CTREE(tree), node, sibling ); }
		void flush();
		void output_to_povray( ofstream & file );
		bool is_used() { return finish->value(); }

		void save( ofstream & file );
		bool load( ifstream & file, char * tag );
				
		bool paste( MaterialItem *item );

};

#endif
