//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// texnormal.h
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2005 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 
//*******************************************************************************************
#ifndef TEXNORMAL_H
#define TEXNORMAL_H
using namespace std;
#include "material.h"
#include "mapedit.h"
#include "slopemap.h"


class PovTexNormal : public MaterialItem {
	#define SENDER ((PovTexNormal*)data)
	friend void sign_normal_type_changed( GtkWidget *wid, gpointer data ) { SENDER->type_changed(); }
	friend void sign_normblocktype_changed( gpointer data ) { SENDER->set_normblock_items(); }
	friend MapItem *mapedit_feeder_normal( gpointer data );
	#undef SENDER


	private:
		bool is_mother;
		
		TvWidget_bool_activator *use;
		TvWidget_option_combo *type;
		TvWidget_float *bump_depth;
		TvWidget_bool *no_bump_scale;
		TvWidget_blendmap *pattern;
		TvWidget_blendmap_mod *blendmod;
		TvWidget_transformation_rb *transform;
		TvWidget_noise_rb *noise;
		TvWidget_warp_rb *warp;
		TvWidget_blockpattern *blockpattern;
		PovTexNormal *normal1, *normal2, *normal3;
		TvWidget_map_editor *mapedit;
		TvWidget_bumpmap *bumpmap;
		TvWidget_slopemap_rb *slopemap;
		TvWidget_float *accuracy;

		GtkWidget *activated_box;
		GtkWidget *changing_box1, *changing_box2;

	public:
		PovTexNormal( app_objs *appref, char *sname, bool mother = true );
		PovTexNormal( PovTexNormal & ref );
		MaterialItem *duplicate_yourself() { PovTexNormal *res = new PovTexNormal( *this ); return res; }
		void set_params( bool mum ) { is_mother = mum; }
		virtual ~PovTexNormal();

		void edit_widget( GtkWidget *box );
		void destroy_widget();
		virtual void add_to_tree( GtkTreeView *view, GtkTreeStore *store, GtkTreeSelection *selection, GtkTreeIter *parent, GtkTreeIter *sibling = NULL  );
		void remove_from_tree();
		void flush();
		void output_to_povray( ofstream & file, bool in_map = false );
		bool is_used() { return use->value(); }

		void type_changed();
		void set_changing_box();

		void set_normblock_items();
		void save( ofstream & file );
		bool load( ifstream & file, char * tag );
		
		bool paste( MaterialItem * item );
		void save_node_state();
};


//****************************************************
// MapItem normal class
//****************************************************
class MapItem_normal : public MapItem {
	protected:
		PovTexNormal *normal;
		static int obj_count;
		void refresh_name() { name = normal->get_name(); }

	public:
		MapItem_normal( float val, guint8 c, app_objs *appref );
		MapItem_normal( MapItem_normal & ref );
		virtual MapItem *duplicate_yourself()  { MapItem_normal *res = new MapItem_normal( *this ); res->normal->set_params( false ); return res; }
		~MapItem_normal() { delete normal; }

		void add_to_tree( GtkTreeView *view, GtkTreeStore *store, GtkTreeSelection *selection, GtkTreeIter *parent, GtkTreeIter *sibling = NULL  ) { normal->add_to_tree( view, store, selection, parent, sibling ); }
		void remove_from_tree() { normal->remove_from_tree(); }
		void output_to_povray( ofstream & file ) { normal->output_to_povray( file, true ); }

		void save( ofstream & file );
		bool load( ifstream & file, char * tag );
		void save_node_state() { normal->save_node_state(); }
};


#endif
