//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// texpigment.h
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2001 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 
//*******************************************************************************************
#ifndef TEXPIGMENT_H
#define TEXPIGMENT_H
using namespace std;
#include "material.h"
#include "mapedit.h"

//****************************************************
// Pigment class
//****************************************************
class PovTexPigment : public MaterialItem {
	#define SENDER ((PovTexPigment*)data)
	friend void sign_pigtype_changed( GtkWidget *wid, gpointer data ) { SENDER->type_changed(); }
	friend void sign_colblocktype_changed( gpointer data ) { SENDER->set_colblock_items(); }	
	friend void sign_pigblocktype_changed( gpointer data ) { SENDER->set_pigblock_items(); }
	friend MapItem *mapedit_feeder_pig( gpointer data );
	friend MapItem *mapedit_feeder_col( gpointer data );
	#undef SENDER
	
	private:
		bool is_mother;
		
		TvWidget_bool_activator *used;
		TvWidget_option_combo *type;
		TvWidget_pigment *solid1, *solid2, *solid3;
		TvWidget_blockpattern *blockpattern;
		TvWidget_transformation_rb *transform;
		TvWidget_noise_rb *noise;
		TvWidget_warp_rb *warp;
		TvWidget_blendmap *blendmap;
		TvWidget_blendmap_mod *blendmap_mod;
		TvWidget_map_editor *mapedit;
		TvWidget_bitmap *bitmap_def;

		PovTexPigment *blockpig1, *blockpig2, *blockpig3;

		GtkWidget *activated_box;
		GtkWidget *changing_box, *changing_box2;
		
	public:
		PovTexPigment( app_objs *appref, char *sname, bool mother = true );
		PovTexPigment( PovTexPigment & ref );
		MaterialItem *duplicate_yourself() { PovTexPigment *res = new PovTexPigment( *this ); return res; }
		void set_params( bool mum ) { is_mother = mum; }
		virtual ~PovTexPigment();

		void edit_widget( GtkWidget *box );
		void destroy_widget();
		void add_to_tree( GtkTreeView *view, GtkTreeStore *store, GtkTreeSelection *selection, GtkTreeIter *parent, GtkTreeIter *sibling = NULL  );
		void remove_from_tree();
		void flush();
		void output_to_povray( ofstream & file, bool in_map=false );
		bool is_used() { return used->value(); }

		void type_changed();
		void set_changing_widget();
		void set_pigblock_items();
		void set_colblock_items();

		void save( ofstream & file );
		bool load( ifstream & file, char *tag );
		
		bool paste( MaterialItem *item );
		void save_node_state();
};


//****************************************************
// MapItem pigment class
//****************************************************
class MapItem_pigment : public MapItem {
	protected:
		PovTexPigment *pigment;
		static int obj_count;
		void refresh_name() { name = pigment->get_name(); }

	public:
		MapItem_pigment( float val, guint8 c, app_objs *appref );
		MapItem_pigment( MapItem_pigment & ref );
		virtual MapItem *duplicate_yourself() { MapItem_pigment *res = new MapItem_pigment( *this ); res->pigment->set_params( false ); return res; }
		~MapItem_pigment() { delete pigment; }

		void add_to_tree( GtkTreeView *view, GtkTreeStore *store, GtkTreeSelection *selection, GtkTreeIter *parent, GtkTreeIter *sibling = NULL  ) { pigment->add_to_tree( view, store, selection, parent, sibling ); }
		void remove_from_tree() { pigment->remove_from_tree(); }
		void output_to_povray( ofstream & file ) { pigment->output_to_povray( file, true ); }
		void save( ofstream & file );
		bool load( ifstream & file, char * tag );
		void save_node_state() { pigment->save_node_state(); }
};


//****************************************************
// MapItem solid color
//****************************************************
class MapItem_color : public MapItem {
	#define SENDER ((MapItem_color*)data)
	friend void sign_mapitemcol_changed( gpointer data ) { SENDER->changed(); }
	#undef SENDER

	protected:
		TvWidget_pigment *solcol;
		char *label;
		void (*func)(gpointer);
		gpointer func_data;
		static int obj_count;

	public:
		MapItem_color( float val, guint8 c, app_objs *appref );
		MapItem_color( MapItem_color & col );
		virtual MapItem *duplicate_yourself() { MapItem_color *res = new MapItem_color( *this ); return res; }
		~MapItem_color() { delete solcol; delete label; }

		void get_editor( GtkWidget *box, bool tt );
		void destroy_editor();
		void changed();
		void update_editor() { solcol->set( (double)color[0]/255, (double)color[1]/255, (double)color[2]/255, (255-color[3]) / 255.0 ); }

		void output_to_povray( ofstream & file ) { solcol->output_to_povray( file ); }
		void connect_signal( void (*f)(gpointer), gpointer d ) { func = f; func_data = d; }

		void save( ofstream & file );
		bool load( ifstream & file, char * tag );
};



#endif
