//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// tvio.h
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2001 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 
//*******************************************************************************************
#ifndef TVIO_H
#define TVIO_H
using namespace std;
#include <iostream>
#include <fstream>

#define MAX_TAG_SIZE 45

bool tvio_check_file_sig( ifstream & file, char *sig );
char *tvio_get_soft_version( ifstream & file );

char *tvio_get_next_tag( ifstream & file );
bool tvio_skip_section( ifstream & file );


char *tvio_get_next_val( ifstream & file );
char *tvio_get_value_as_string( ifstream & file );
float tvio_get_value_as_float( ifstream & file );
int tvio_get_value_as_int( ifstream & file );
bool tvio_get_value_as_bool( ifstream & file );

#endif
