//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// utils3d.h
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2001 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 
//*******************************************************************************************
#ifndef UTILS3D_H
#define UTILS3D_H
using namespace std;

typedef float tv_matrix[4][4];
typedef float tv_vector[4];
typedef float tv_point[3];

void normalize( tv_point & pt );

void transpose_matrix( tv_matrix & source, tv_matrix & dest );
void prod_matrix_matrix( tv_matrix & m1, tv_matrix & m2, tv_matrix & dest );
void prod_matrix_vector( tv_matrix & m1, tv_vector & v1,  tv_vector & dest );
void prod_vector_matrix( tv_vector & v1, tv_matrix & m1,  tv_vector & dest );
float  prod_vector_vector( tv_vector & v1, tv_vector & v2 );
void prod_vector( tv_point & v1, tv_point & v2,  tv_point & dest );

float square( float a );
void get_normal( float ax, float ay, float az, float bx, float by, float bz, float cx, float cy, float cz, bool invert = false );
void get_normal( float *a, float *b, float *c ) ;
void get_normal( float *a, float *b, float *c, float *d, bool invert = false );
void get_normal( float *a, float *b, float *c, float *d, float *dest, bool invert = false );

#endif
