//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// viewmanager.h
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2005 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 
//*******************************************************************************************
#ifndef VIEWMANAGER_H
#define VIEWMANAGER_H
using namespace std;
#include <iostream>
#include "main.h"
#include "glview3d.h"
#include "glview2d.h"

#define VMAN_DEF ViewManager *vmanager = (ViewManager*)(app_ref->vmanager);

//**********************************************
// Pointer modes definition
//**********************************************
#define MAX_PMODE 6
enum PointType {
	TV_PMODE_TRACKBALL,
	TV_PMODE_SELECT,
	TV_PMODE_SCALE,
	TV_PMODE_ROTATE,
	TV_PMODE_TRANSLATE,	
	TV_PMODE_CUSTOM,
	};
typedef PointType PointerMode;


//*************************************************************
// Class ViewManager
//
// manager the 4 gl preview widgets
//*************************************************************
class ViewManager: private app_object {
	private:
		// Generals
		app_objs *app_ref;
	
		// Widgets & datas
		GtkWidget *vbox1, *vbox2;
		GdkCursor *pointeur;
		glview *views[4];
		PointerMode pointer_mode;
		GtkAction *pointer_actions[MAX_PMODE-1];
	
		// Locks
		bool pmode_in_change;
		bool freezed;

	public:
		ViewManager( app_objs *app_ref, GtkWidget *parent, GtkUIManager *ui_manager );
		~ViewManager() { }
		
		void pref_changed();

		// Save & load
		void save( ofstream & file );
		bool load( ifstream & file, char *tag );
		void clear();
		void freeze() { freezed = true; }
		void thaw() { freezed = false; }
		void invalidate() {  if ( !freezed ) for ( int i = 0 ; i < 4 ; i++ ) views[i]->invalidate(); }

		// Manage views
		void refresh() { if ( !freezed ) for ( int i = 0 ; i < 4 ; i++ ) views[i]->refresh(); }
		void force_refresh() { if ( !freezed ) for ( int i = 0 ; i < 4 ; i++ ) views[i]->force_refresh(); }

		void hide_sisters( glview *view, GtkWidget *container );
		void unhide_sisters();

		void change_view( glview *oldone, ViewType type, GtkWidget *box, GtkWidget *area_frame, GtkWidget *tbar_frame, bool maximized );

		// Pointer mode management
		void set_pointer_mode( PointerMode pmode = (PointerMode)(-1) );
		void set_custom_pointer_mode( GdkCursorType cursor );
		void set_pointer_actions( GtkUIManager *ui_manager );
		void sign_pmode_change( GtkAction *action );
		void unset_cursor();
		PointerMode get_pointer_mode() { return pointer_mode; }			
		
};
#endif
