
AC_DEFUN([AM_PATH_PYTHON],
 [
  dnl Find a Python interpreter.  Python versions prior to 1.5 are not
  dnl supported because the default installation locations changed from
  dnl $prefix/lib/site-python in 1.4 to $prefix/lib/python1.5/site-packages
  dnl in 1.5.
  m4_define([_AM_PYTHON_INTERPRETER_LIST],
            [python python2 python2.2 python2.1 python2.0 python1.6 python1.5])

  m4_if([$1],[],[
    dnl No version check is needed.
    # Find any Python interpreter.
    AC_PATH_PROG([PYTHON], _AM_PYTHON_INTERPRETER_LIST)],[
    dnl A version check is needed.
    if test -n "$PYTHON"; then
      # If the user set $PYTHON, use it and don't search something else.
      AC_MSG_CHECKING([whether $PYTHON version >= $1])
      AM_PYTHON_CHECK_VERSION([$PYTHON], [$1],
                              [AC_MSG_RESULT(yes)],
                              [AC_MSG_ERROR(too old)])
    else
      # Otherwise, try each interpreter until we find one that satisfies
      # VERSION.
      AC_CACHE_CHECK([for a Python interpreter with version >= $1],
        [am_cv_pathless_PYTHON],[
        for am_cv_pathless_PYTHON in _AM_PYTHON_INTERPRETER_LIST : ; do
          if test "$am_cv_pathless_PYTHON" = : ; then
            AC_MSG_ERROR([no suitable Python interpreter found])
          fi
          AM_PYTHON_CHECK_VERSION([$am_cv_pathless_PYTHON], [$1], [break])
        done])
      # Set $PYTHON to the absolute path of $am_cv_pathless_PYTHON.
      AC_PATH_PROG([PYTHON], [$am_cv_pathless_PYTHON])
    fi
  ])

  dnl Query Python for its version number.  Getting [:3] seems to be
  dnl the best way to do this; it's what "site.py" does in the standard
  dnl library.

  AC_CACHE_CHECK([for $am_cv_pathless_PYTHON version], [am_cv_python_version],
    [am_cv_python_version=`$PYTHON -c "import sys; print sys.version[[:3]]"`])
  AC_SUBST([PYTHON_VERSION], [$am_cv_python_version])

  dnl Use the values of $prefix and $exec_prefix for the corresponding
  dnl values of PYTHON_PREFIX and PYTHON_EXEC_PREFIX.  These are made
  dnl distinct variables so they can be overridden if need be.  However,
  dnl general consensus is that you shouldn't need this ability.

  AC_SUBST([PYTHON_PREFIX], ['${prefix}'])
  AC_SUBST([PYTHON_EXEC_PREFIX], ['${exec_prefix}'])

  dnl At times (like when building shared libraries) you may want
  dnl to know which OS platform Python thinks this is.

  AC_CACHE_CHECK([for $am_cv_pathless_PYTHON platform],
                 [am_cv_python_platform],
    [am_cv_python_platform=`$PYTHON -c "import sys; print sys.platform"`])
  AC_SUBST([PYTHON_PLATFORM], [$am_cv_python_platform])


  dnl Set up 4 directories:

  dnl pythondir -- where to install python scripts.  This is the
  dnl   site-packages directory, not the python standard library
  dnl   directory like in previous automake betas.  This behaviour
  dnl   is more consistent with lispdir.m4 for example.

  dnl Query distutils for this directory.  distutils does not exist in
  dnl Python 1.5, so we fall back to the hardcoded directory if it
  dnl doesn't work.
  AC_CACHE_CHECK([for $am_display_PYTHON script directory],
    [am_cv_python_pythondir],
    [am_cv_python_pythondir=`$PYTHON -c "from distutils import sysconfig; print sysconfig.get_python_lib(0,0,prefix='$PYTHON_PREFIX')" 2>/dev/null ||
    echo "$PYTHON_PREFIX/lib/python$PYTHON_VERSION/site-packages"`])
  AC_SUBST([pythondir], [$am_cv_python_pythondir])

  dnl pkgpythondir -- $PACKAGE directory under pythondir.  Was
  dnl   PYTHON_SITE_PACKAGE in previous betas, but this naming is
  dnl   more consistent with the rest of automake.

  AC_SUBST([pkgpythondir], [\${pythondir}/$PACKAGE])

  dnl pyexecdir -- directory for installing python extension modules
  dnl   (shared libraries)
  dnl Query distutils for this directory.  distutils does not exist in
  dnl Python 1.5, so we fall back to the hardcoded directory if it
  dnl doesn't work.
  AC_CACHE_CHECK([for $am_display_PYTHON extension module directory],
    [am_cv_python_pyexecdir],
    [am_cv_python_pyexecdir=`$PYTHON -c "from distutils import sysconfig; print sysconfig.get_python_lib(1,0,prefix='$PYTHON_EXEC_PREFIX')" 2>/dev/null ||
     echo "${PYTHON_EXEC_PREFIX}/lib/python${PYTHON_VERSION}/site-packages"`])
  AC_SUBST([pyexecdir], [$am_cv_python_pyexecdir])

  dnl pkgpyexecdir -- $(pyexecdir)/$(PACKAGE)

  AC_SUBST([pkgpyexecdir], [\${pyexecdir}/$PACKAGE])
])
# AM_PYTHON_CHECK_VERSION(PROG, VERSION, [ACTION-IF-TRUE], [ACTION-IF-FALSE])
# ---------------------------------------------------------------------------
# Run ACTION-IF-TRUE if the Python interpreter PROG has version >= VERSION.
# Run ACTION-IF-FALSE otherwise.
# This test uses sys.hexversion instead of the string equivalant (first
# word of sys.version), in order to cope with versions such as 2.2c1.
# hexversion has been introduced in Python 1.5.2; it's probably not
# worth to support older versions (1.5.1 was released on October 31, 1998).
AC_DEFUN([AM_PYTHON_CHECK_VERSION],
 [prog="import sys, string
# split strings by '.' and convert to numeric.  Append some zeros
# because we need at least 4 digits for the hex conversion.
minver = map(int, string.split('$2', '.')) + [[0, 0, 0]]
minverhex = 0
for i in xrange(0, 4): minverhex = (minverhex << 8) + minver[[i]]
sys.exit(sys.hexversion < minverhex)"
  AS_IF([AM_RUN_LOG([$1 -c "$prog"])], [$3], [$4])])


AC_DEFUN([AM_CHECK_PYTHON_HEADERS],
[AC_REQUIRE([AM_PATH_PYTHON])
AC_MSG_CHECKING(for headers required to compile python extensions)
dnl deduce PYTHON_INCLUDES
py_prefix=`$PYTHON -c "import sys; print sys.prefix"`
py_exec_prefix=`$PYTHON -c "import sys; print sys.exec_prefix"`
PYTHON_INCLUDES="-I${py_prefix}/include/python${PYTHON_VERSION}"
if test "$py_prefix" != "$py_exec_prefix"; then
  PYTHON_INCLUDES="$PYTHON_INCLUDES -I${py_exec_prefix}/include/python${PYTHON_VERSION}"
fi
AC_SUBST(PYTHON_INCLUDES)
dnl check if the headers exist:
save_CPPFLAGS="$CPPFLAGS"
CPPFLAGS="$CPPFLAGS $PYTHON_INCLUDES"
AC_TRY_CPP([#include <Python.h>],dnl
[AC_MSG_RESULT(found)
$1],dnl
[AC_MSG_RESULT(not found)
$2])
CPPFLAGS="$save_CPPFLAGS"

# Check for Python library path
AC_MSG_CHECKING([for Python library path])
python_path=`echo $PYTHON | sed "s,/bin.*$,,"`
for i in "$python_path/lib/python$PYTHON_VERSION/config/" "$python_path/lib/python$PYTHON_VERSION/" "$python_path/lib/python/config/" "$python_path/lib/python/" "$python_path/" ; do
python_path=`find $i -type f -name libpython$PYTHON_VERSION.* -print | sed "1q"`
if test -n "$python_path" ; then
	break
fi
done
python_path=`echo $python_path | sed "s,/libpython.*$,,"`
AC_MSG_RESULT([$python_path])
if test -z "$python_path" ; then
    AC_MSG_ERROR([cannot find Python library path])
fi
AC_SUBST([PYTHON_LDFLAGS],["-L$python_path -lpython$PYTHON_VERSION"])
])

########################################################
# TRUEVISION_WITH_PYTHON

AC_DEFUN([TRUEVISION_WITH_PYTHON], [
AC_SUBST(TRUEVISION_PYTHON_SUBDIR)
AC_SUBST(TRUEVISION_PYTHON_CPPFLAGS)
AC_SUBST(TRUEVISION_PYTHON_LIBADD)
AC_SUBST(TRUEVISION_PYTHON_LDFLAGS)
AC_ARG_WITH(python,[  --with-python[[=PATH]]    build python-based script engine [[no]]],[],[withval=no])
if test x$withval != xno; then
        if test -z "$PYTHON"; then
                AC_PATH_PROGS(PYTHON, python python2.2 python2.3)
        fi
        changequote(, )
        TRUEVISION_PYTHON_VERSION=`$PYTHON -c "import sys; print sys.version[:3]"`
        changequote([, ])
        AC_MSG_RESULT([found Python version $TRUEVISION_PYTHON_VERSION])
        if test x$withval = xyes; then
                truevision_python_prefix=/usr
        else
                truevision_python_prefix=$withval
        fi

        if $truevision_win32; then
                AC_CHECK_HEADER([$truevision_python_prefix/include/Python.h],
                [
                        TRUEVISION_PYTHON_SUBDIR="python"
                        TRUEVISION_PYTHON_CPPFLAGS="-I$truevision_python_prefix/include"
                        TRUEVISION_PYTHON_LIBADD=""
                        TRUEVISION_PYTHON_LDFLAGS="c:/windows/system32/python${TRUEVISION_PYTHON_VERSION}.dll"
                ],
                [
                AC_MSG_ERROR([
        Couldn't find Python.h ... if you don't require python support, re-run
        configure with the --without-python option

        If you wish to include support and have Python installed in a directory
        configure can't find, try specify the basepath to library and header:
  ./configure --with-python=c:/pythonXX

                ])
                ])
        else
                AC_CHECK_HEADER([$truevision_python_prefix/include/python${TRUEVISION_PYTHON_VERSION}/Python.h],
                [
                        TRUEVISION_PYTHON_SUBDIR="python"
                        TRUEVISION_PYTHON_CPPFLAGS="-I$truevision_python_prefix/include/python${TRUEVISION_PYTHON_VERSION}"
                        TRUEVISION_PYTHON_LIBADD="-L$truevision_python_prefix/lib/python${TRUEVISION_PYTHON_VERSION}/config -lpython${TRUEVISION_PYTHON_VERSION} -lutil"
                        TRUEVISION_PYTHON_LDFLAGS="-Xlinker -export-dynamic"
                ],
                [
                AC_MSG_ERROR([
        Couldn't find Python.h ... if you don't require python support, re-run
        configure with the --without-python option

        If you wish to include support and have Python installed in a directory
        configure can't find, try specify the basepath to library and header:

                ./configure --with-python=/usr/local

        To find out the path, type:

                locate Python.h

        If the above return '/usr/local/include/python2.3/Python.h' the basepath
        will in that case be '/usr/local'.
                ])
                ])
        fi
fi
])
