import pygtk
pygtk.require('2.0')
import gtk

class HelloWorld:
    def ok_button(self, widget, data=None):
        self.num_of_stars = self.spinner.get_value_as_int();
        
    def delete_event(self, widget, event, data=None):
        return False
   
    def destroy(self, widget, data=None):
        gtk.main_quit();
        
    def __init__(self):
        self.window = gtk.Window(gtk.WINDOW_TOPLEVEL)
        self.window.connect("delete_event", self.delete_event)
        self.window.connect("destroy", self.destroy)
        self.window.set_border_width(10)

        main_vbox = gtk.VBox(False, 5)
        main_vbox.set_border_width(10)
        self.window.add(main_vbox)

        frame = gtk.Frame("Starfield");
        main_vbox.pack_start(frame, True, True, 0);

        hbox = gtk.HBox(False, 0);
        frame.add(hbox);

        label = gtk.Label("Stars :");
        label.set_alignment(0, 0.5);
        hbox.pack_start(label, True,True, 0);
        
        self.adj = gtk.Adjustment(2000.0, 100.0, 20000.0, 100.0, 500.0, 0.0);
        self.spinner = gtk.SpinButton(self.adj, 0, 0);
        self.spinner.set_wrap(False);
        hbox.pack_start(self.spinner, False, True, 0);

        hbox = gtk.HBox(False, 0)
        main_vbox.pack_start(hbox, False, True, 0);
   
        self.button = gtk.Button("OK")
        self.button.connect("clicked", self.ok_button, None)
        self.button.connect_object("clicked", gtk.Widget.destroy, self.window)
        hbox.pack_start(self.button, True, True, 5);
        self.window.show_all()

    def get_stars(self):
        return self.num_of_stars;

    def set_stars(self, n):
        self.num_of_stars = n;
        self.spinner.set_value(n);
        
    def main(self):
        gtk.main()


def edit():
    s = ScriptObj();
    hello = HelloWorld();
    hello.set_stars( s.get_int("Stars") );
    hello.main();
    s.set_int("Stars", hello.get_stars());
    
def create():
    s = ScriptObj();
    s.new_int("Stars", 2000);    
    s.set_has_rotation(0);
    s.set_has_location(0);
    s.set_has_scale(0);
    s.set_has_material(0);
    s.set_has_editbutton(1);
    s.set_name("Starfield");
    s.set_script_path(_App.filename);
    layer=Layer();
    layer.add_object(s);
    scene=Scene();
    scene.add_layer(layer);

def povpass1():
    s = ScriptObj();
    
    num_of_stars = s.get_int( "Stars");
#######################
    str = 'union{\n\
    #declare S0=seed(0);\n\
    #declare Count=0;\n\
    #declare num_of_stars=%(num)d;\n\
    #declare Diameter=2;\n\
    #declare Distance=image_height * Diameter;\n\
    #while (Count < num_of_stars)\n\
    sphere { z * Distance,Diameter/2\n\
    no_shadow\n\
    pigment { rgb 1 }\n\
    finish { ambient 10000 diffuse 0 specular 0 phong 0 reflection 0 }\n\
    rotate < 360*rand(S0),360*rand(S0),360*rand(S0) >\n\
    translate <0,0,0>\n\
    }\n\
    #declare Count=Count+1;\n\
    #end\n' %\
    {'num': num_of_stars}
    s.set_pov_pass1(str);
    
def povpass2():
    #s = ScriptObj();
    #s.set_pov_pass1("Pass2");
    print("POVPass2");

def register():
    _App.register_script(_App.filename, "Starfield", "This script creates a starfield", "Christian Spoer", "Christian Spoer", "2005", "*", "<ScriptMenu>/Starfield");
    
##################
# Main
##################

try:
    run_mode = _App.run_mode;
    if run_mode == 0:
        register();
    elif run_mode == 1:
        create();
    elif run_mode == 2:
        edit();
    elif run_mode == 3:
        povpass1();
    elif run_mode == 4:
        povpass2();
    else:
        print("Else");
        create();
except AttributeError:
    print("AttributeError");
    create();
