//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// atmosphere.cc
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2005 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 
//*******************************************************************************************
#include "include/atmosphere.h"
#include "include/viewmanager.h"
#include "include/objectlist.h"
#include "include/tvio.h"
#include "include/matpov.h"
#include "include/preferences.h"

//**************************************
// Constructeur
//**************************************
Background::Background( app_objs *appref ) : Object3D( appref )
{
type = TV_OBJ3D_BKGD;
category = TV_OBJ3D_ATMOS1;
set_name( "Background" );
color = new TvWidget_pigment( N_("Color"), "COLOR", _("Color of backgorund"), app_ref );
color->set( 0, 0, 0, 0 );
}

Background::~Background()
{
delete color;
}

//***********************************************
// Edit
//***********************************************
void Background::edit_widget( GtkWidget *wid )
{
PREF_DEF
bool tt = pref->tooltips->value();
Object3D::edit_widget( wid, false );

new_frame( edit_cont, _("Definition") );
color->get_widget( frame, tt );
gtk_widget_show_all( wid );
}

//***********************************************
// Pref_changed
//***********************************************
void Background::pref_changed()
{
Object3D::pref_changed();
color->pref_changed();
}

//***********************************************
// Destroy editor
//***********************************************
void Background::destroy_editor()
{
Object3D::destroy_editor();
color->clear_widget();
}

//***********************************************
// Output to povray
//***********************************************
void Background::output_to_povray_pass1( ofstream & file )
{
if ( !render->value() ) return;
file << "\n\n// Background : " << name->value();
file << "\n#declare "; get_underscore_name( file ); file << " ="; 
file << "\n\nbackground {\n\t";
color->output_to_povray( file );
file << "\n}";
}

void Background::save( ofstream & file )
{
file << "\nBACKGROUND{\n";
save_basics( file );
color->save( file );
file << "\n}";
}


bool Background::load( ifstream & file, char *ltag )
{
if ( strcmp( ltag, "BACKGROUND" ) ) return false;
set_load_progress( file );
char * tag = NULL;
do {
	tag = tvio_get_next_tag( file );
	if ( tag == NULL ) break;
	
	if ( load_basics( file, tag ) ) continue;
 	if ( color->load( file, tag ) ) continue;
		
	tvio_skip_section(file );
	} while ( tag != NULL );

return true;
}






//**************************************
// Constructeur
//**************************************
SkySphere::SkySphere( app_objs *appref ) : Object3D_with_material( appref )
{
type = TV_OBJ3D_SKY;
category = TV_OBJ3D_ATMOS1;
set_name( "Sky Sphere" );
}


//***********************************************
// Edit
//***********************************************
void SkySphere::edit_widget( GtkWidget *wid )
{
PREF_DEF
bool tt = pref->tooltips->value();
Object3D::edit_widget( wid, false );

new_frame( edit_cont, _("Definition") );
texture->get_widget( frame, tt );
gtk_widget_show_all( wid );
}



//***********************************************
// Output to povray
//***********************************************
void SkySphere::output_to_povray_pass1( ofstream & file )
{
if ( !render->value() ) return;
PovMaterial *mat = ((PovMaterial*)texture->get_current());
if ( mat == NULL ) return;
file << "\n\n// Sky Sphere : " << name->value();
file << "\n#declare "; get_underscore_name( file ); file << " ="; 
file << "\n\nsky_sphere {\n\t";
if ( mat->has_pigment() ) mat->output_to_povray_pigment( file );
else file << "pigment { color 0 }";
file << "\n}";
}


void SkySphere::save( ofstream & file )
{
file << "\nSKY{\n";
save_basics( file );
texture->save( file );
file << "\n}";
}


bool SkySphere::load( ifstream & file, char *ltag )
{
if ( strcmp( ltag, "SKY" ) ) return false;
set_load_progress( file );

char * tag = NULL;
do {
	tag = tvio_get_next_tag( file );
	if ( tag == NULL ) break;
	
	if ( load_basics( file, tag ) ) continue;
	tvio_skip_section(file );
	} while ( tag != NULL );

return true;
}


//**************************************
// Atmospheric Media
// Constructeur
//**************************************
AtmosMedia::AtmosMedia( app_objs *appref ) : Object3D_with_material( appref )
{
type = TV_OBJ3D_AMEDIA;
category = TV_OBJ3D_ATMOS2;
set_name( "Atmospheric Media" );
}


//***********************************************
// Edit
//***********************************************
void AtmosMedia::edit_widget( GtkWidget *wid )
{
PREF_DEF
bool tt = pref->tooltips->value();
Object3D::edit_widget( wid, false );

new_frame( edit_cont, _("Definition") );
texture->get_widget( frame, tt );
gtk_widget_show_all( wid );
}



//***********************************************
// Output to povray
//***********************************************
void AtmosMedia::output_to_povray_pass1( ofstream & file )
{
if ( !render->value() ) return;
PovMaterial *mat = ((PovMaterial*)texture->get_current());
if ( mat == NULL ) return;
file << "\n\n// Athmospheric media : " << name->value();
mat->output_to_povray_media( file );
}


void AtmosMedia::save( ofstream & file )
{
file << "\nAMEDIA{\n";
texture->save( file );
file << "\n}";
}


bool AtmosMedia::load( ifstream & file, char *ltag )
{
if ( strcmp( ltag, "AMEDIA" ) ) return false;
set_load_progress( file );

char * tag = NULL;
do {
	tag = tvio_get_next_tag( file );
	if ( tag == NULL ) break;
	
	if ( load_basics( file, tag ) ) continue;
	tvio_skip_section(file );
	} while ( tag != NULL );

return true;
}
