//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// dlgutils.cc
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2005 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 
//******************************************************************************************
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "include/dlgutils.h"
#include <unistd.h>
#include <libintl.h>
#include "include/main.h"
#include "include/preferences.h"
#include "config.h"


//***********************************************
// FRAMES
//***********************************************

// Frame
GtkWidget *dlg_frame( const char *titre, GtkWidget *parent )
{
GtkWidget *frame = gtk_frame_new( titre );
gtk_frame_set_shadow_type( GTK_FRAME(frame), GTK_SHADOW_ETCHED_OUT );
gtk_box_pack_start( GTK_BOX(parent), frame, FALSE, TRUE, 2 );
return frame;
}

// Double box
GtkWidget *dlg_double_box( GtkWidget *parent, GtkWidget* &vbox1, GtkWidget* &vbox2, bool packed  )
{
GtkWidget *hbox = gtk_hbox_new( TRUE, 5 );
if ( packed ) gtk_box_pack_start( GTK_BOX(parent), hbox, TRUE, TRUE, 1 );
else gtk_container_add( GTK_CONTAINER(parent), hbox );

vbox1 = gtk_vbox_new( FALSE, 2 );
vbox2 = gtk_vbox_new( FALSE, 2 );
gtk_box_pack_start( GTK_BOX(hbox), vbox1, TRUE, TRUE, 1 );
gtk_box_pack_start( GTK_BOX(hbox), vbox2, TRUE, TRUE, 1 );
return hbox;
}

// Simple box in a frame
GtkWidget *dlg_simple_box_frame( const char *titre, GtkWidget *parent )
{
GtkWidget *frame = dlg_frame( titre, parent );
GtkWidget *vbox = gtk_vbox_new( FALSE, 5 );
gtk_container_add( GTK_CONTAINER(frame), vbox );
return vbox;
}


// Double box in a frame
GtkWidget *dlg_double_box_frame( const char *titre, GtkWidget *parent, GtkWidget* &vbox1, GtkWidget* &vbox2 )
{
GtkWidget *frame = dlg_frame( titre, parent );
GtkWidget *hbox = dlg_double_box( frame, vbox1, vbox2 );
return hbox;
}

GtkWidget *new_table( GtkWidget *wid, const char *nom, int rows )
{
GtkWidget *Frame = gtk_frame_new( nom );
gtk_box_pack_start( GTK_BOX(wid), Frame, FALSE, TRUE, 6 );
GtkWidget *table = gtk_table_new( rows, 4, FALSE );
gtk_container_add( GTK_CONTAINER(Frame), table );
gtk_container_set_border_width( GTK_CONTAINER(table), 3 );
return table;
}

GtkWidget *new_table_no_frame( GtkWidget *box, int rows )
{
GtkWidget *table = gtk_table_new( rows, 4, FALSE );
gtk_box_pack_start( GTK_BOX(box), table, FALSE, TRUE, 6 );
gtk_container_set_border_width( GTK_CONTAINER(table), 3 );
return table;
}

//***********************************************
// NOTEBOOK
//***********************************************
// new page
GtkWidget *dlg_new_page( GtkWidget *notebook, const char *lab )
{
GtkWidget *vbox = gtk_vbox_new( FALSE, 5 );
gtk_container_set_border_width( GTK_CONTAINER(vbox), 5 );
GtkWidget *wlab = gtk_label_new( lab );
gtk_notebook_append_page( GTK_NOTEBOOK(notebook), vbox, wlab );
return vbox;
}


//***********************************************
// Temp File
//***********************************************
const char *tmp_path = "/tmp";

char *get_temp_filename()
{
char *path = NULL;
if ( access( tmp_path, F_OK ) != -1 ) path = (char*)tmp_path;
//else { cout << "\nCannot access tmp path"; cout.flush(); }
char *res = new char[ (( path == NULL ) ? 0 : strlen(path)) + 50 ];

int i;
for ( i = 0 ; i < 10000 ; i++ )
	{
	if ( path != NULL ) sprintf( res, "%s/tv%u.tmp", path, i );
	else  sprintf( res, "tv%u.tmp", i );
	if ( access( res, F_OK ) == -1 ) break;
	}
 if ( i == 10000 ) app_fatal_err( _("Cannot create valid temp file name, too much used !") ); 
return res;
}

char*
get_temp_directory()
{
	char *path = NULL;
	if ( access( tmp_path, F_OK ) != -1 ) {
		path = (char*)tmp_path;
	} else {
		printf("\nCannot access tmp path"); fflush(stdout);
	}
	char *res = new char[ (( path == NULL ) ? 0 : strlen(path)) + 50 ];
	int i, mdir;
	for ( i = 0 ; i < 10000 ; i++ ) {
		if ( path != NULL )
			sprintf( res, "%s/tv_tmp_dir%u/", path, i );
		else
			sprintf( res, "tv_tmp_dir%u/", i );

		mdir = mkdir( res, 0777);
		
			
		if (  mdir == -1 && errno == EEXIST)
			continue;
		else if ( mdir == 0 )
			break;
		else
			app_fatal_err( _("Cannot create valid temp directory !") ); 
	}
	if ( i >= 10000 )
		app_fatal_err( _("Cannot create valid temp file name, too much used !") ); 

	return res;
}

void
cp( char* from, char* to)
{
	struct stat st;
	FILE *f1, *f2;
	int n;
	char buffer[1024];

	stat( from, &st );

	if (( f1 = fopen(from, "r")) == NULL ){
		printf("Copy: Opening %s", from);
		return;
	}
	if (( f2 = fopen(to, "w+")) == NULL ) {
		printf("Copy: Creating %s", to);
		return;
	}
	
	while ((n = fread(buffer, sizeof(char), 1024, f1)) > 0)
		if (fwrite(buffer, sizeof(char), n, f2) != (unsigned int )n )
			printf("Copy: Write Error on %s.", to);
	
	fclose(f1);
	fclose(f2);
}

//*********************************************************
// returns 1 if str ends with tok
//*********************************************************
int
ends_with( char* str, char *tok)
{
	int ends = 1;
	int i, len_str, len_tok;
	len_str = strlen(str);
	len_tok = strlen(tok);
	
	if(( len_tok <= len_str ) && (len_str > 0) && (len_tok > 0)) {
		for( i = 0 ; i < len_tok ; i++ ) {
			if( tolower( *(str + len_str - i - 1) ) != tolower( *(tok + len_tok - i - 1) ) ) {
				ends = 0;
				break;
			}
			
		}
	} else {
		ends = 0;
	}

	return ends;
}

//*********************************************************
// returns the filename without the path
//*********************************************************
char*
extract_filename( char *str )
{
	int length, i;
	char *ret_str = NULL;
	
	if( str == NULL )
		return NULL;
	
	length = strlen(str);

	for( i = length - 1 ; i >= 0 ; i-- ) {
		if( str[i] == '/' )
			break;
	}

	if( i > 0 ) {
		ret_str = (char*)malloc( (length - i) );
		strcpy( ret_str, (str + i +1) );
	} else {
		ret_str = strdup( str );
	}
	return ret_str;
}

char *tv_get_pixmap( char *pix )
{
char *res  = new char[ strlen( pix ) + strlen( PACKAGE_PIXMAPS_DIR ) + 2 ];
strcpy( res, PACKAGE_PIXMAPS_DIR );
strcat( res, "/" );
strcat( res, pix );
//cout << "\nPixmap -> " << res; cout.flush();
return res;
}


char *tv_get_data( char *data )
{
char *res  = new char[ strlen( data ) + strlen( PACKAGE_DATA_DIR ) + 2 ];
strcpy( res, PACKAGE_DATA_DIR );
strcat( res, "/" );
strcat( res, data );
//cout << "\ndata -> " << res; cout.flush();
return res;
}


//************************************************
// Splash Screen
//************************************************
SplashScreen::SplashScreen( GnomeProgram *app )
{
splash = gtk_window_new( GTK_WINDOW_POPUP );
gtk_window_set_title( GTK_WINDOW(splash), _("Truevision startup...") );
gtk_window_set_position( GTK_WINDOW(splash), GTK_WIN_POS_CENTER );
gtk_window_set_modal( GTK_WINDOW(splash), TRUE );
gtk_signal_connect( GTK_OBJECT(splash), "delete_event", GTK_SIGNAL_FUNC(sign_splash_closed), this );

GtkWidget *vbox = gtk_vbox_new( FALSE, 0 );
gtk_container_add( GTK_CONTAINER(splash), vbox );

char *fname = tv_get_pixmap( "splash.png" );
GtkWidget *pix = gtk_image_new_from_file( fname );
delete fname;
gtk_box_pack_start( GTK_BOX(vbox), pix, TRUE, TRUE, 0 );

statusbar = gtk_label_new( _("Starting...") );
gtk_box_pack_start( GTK_BOX(vbox), statusbar, TRUE, TRUE, 0 );

gtk_widget_show( pix );
gtk_widget_realize( splash );

gtk_widget_show_all( splash );
while ( gtk_events_pending() ) gtk_main_iteration();
gdk_flush();
}

SplashScreen::~SplashScreen()
{
if ( splash != NULL ) gtk_widget_destroy( splash );
splash = NULL;
while ( gtk_events_pending() ) gtk_main_iteration();
}

void SplashScreen::set_status( char *message )
{
gtk_label_set_text( GTK_LABEL(statusbar), message );
while ( gtk_events_pending() ) gtk_main_iteration();
gdk_flush();
}
