//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// povscript.cc
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2005 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 
//*******************************************************************************************
#include "include/povscript.h"
#include "include/viewmanager.h"
#include "include/objectlist.h"
#include "include/tvio.h"
#include "include/preferences.h"

//**************************************
// Constructeur
//**************************************
PovScript::PovScript( app_objs *appref ) : Object3D_with_material( appref )
{
type = TV_OBJ3D_POVSCRIPT;
category = TV_OBJ3D_OBJECTS;
set_name( "PovScript" );

// Base
script = new TvWidget_TextButton( N_("Edit"), "STR", NULL, appref );
}

PovScript::PovScript( PovScript & ref ) : Object3D_with_material( ref )
{
script = new TvWidget_TextButton( *ref.script );
}

PovScript::~PovScript()
{
delete script;
}


//***********************************************
// Edit
//***********************************************
void PovScript::edit_widget( GtkWidget *wid )
{
bool tt = true;
// Options communes
Object3D::edit_widget( wid );

// Options de geometrie
new_frame( edit_cont, _("General settings") );
script->get_widget( frame, tt );

gtk_widget_show_all( wid );
}

//***********************************************
// Pref_changed
//***********************************************
void PovScript::pref_changed()
{
Object3D::pref_changed();
script->pref_changed();
}

//***********************************************
// Destroy editor
//***********************************************
void PovScript::destroy_editor()
{
Object3D::destroy_editor();
script->clear_widget();
}

//***********************************************
// Output to povray
//***********************************************
void PovScript::output_to_povray_pass1( ofstream & file )
{
PREF_DEF
if ( pref->no_script_exec->value() ) return;
	
file << "\n\n// PovScript : " << name->value();
file << "\n#macro "; get_underscore_name( file );
file << "()\n" << script->value();
file << "\n#end";
}

void PovScript::output_to_povray_pass2( ofstream & file ) 
{
PREF_DEF
if ( pref->no_script_exec->value() ) return;
	
file << "\n"; get_underscore_name( file ); 
file << "()"; 
}

//***********************************************
// Save & load
//***********************************************
void PovScript::save( ofstream & file )
{
file << "\nPOVSCRIPT{\n";
//save_basics( file );
script->save( file );
file << "\n}";
}

bool PovScript::load( ifstream & file, char *ltag )
{
if ( strcmp( ltag, "POVSCRIPT" ) ) return false;
set_load_progress( file );

char * tag = NULL;
do {
	tag = tvio_get_next_tag( file );
	if ( tag == NULL ) break;
	
 	if ( script->load( file, tag ) ) continue;
	
	tvio_skip_section(file );
	} while ( tag != NULL );

return true;
}
