//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// preferences.cc
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2001 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 
//*******************************************************************************************
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <string.h>
#include <iostream>
#include "include/preferences.h"
#include "include/interface.h"
#include "include/dlgutils.h"
#include "include/tvio.h"


//******************************
// Const
//******************************
const int blob_preview_quality_num = 5;
const gchar *blob_preview_quality_list[ blob_preview_quality_num ] = { N_("Lower"), N_("Low"), N_("Medium"), N_("High"), N_("Higher") };
const int preview_quality_num = 3;
const gchar *preview_quality_list[ preview_quality_num ] = {  N_("Low"), N_("Medium"), N_("High") };

//*********************************************
// Preferences
// Constructeur
//*********************************************
Preferences::Preferences( app_objs * appr )
{
// init
app_ref = appr;
app_ref->prefer = (app_object*)this;
changed = false;
dialog = NULL;
selected_page = 0;

// Geometry
save_geo = new TvWidget_bool( N_("Save geometry"), "SAVEGEO", N_("Save window position and size and restore it the next session"), app_ref, true );
PrefList.push_back( save_geo );
win_xpos = new TvWidget_int( NULL, "WINXPOS", NULL, app_ref, 0 );
PrefList.push_back( win_xpos );
win_ypos = new TvWidget_int( NULL, "WINYPOS", NULL, app_ref, 0 );
PrefList.push_back( win_ypos );
win_xsize = new TvWidget_int( NULL, "WINXSIZE", NULL, app_ref, 800 );
PrefList.push_back( win_xsize );
win_ysize = new TvWidget_int( NULL, "WINYSIZE", NULL, app_ref, 600 );
PrefList.push_back( win_ysize );
pan_pos = new TvWidget_int( NULL, "PANPOS", NULL, app_ref, 550 );
PrefList.push_back( pan_pos );
pan_hidden = new TvWidget_bool( NULL, "PANHID", NULL, app_ref, false );
PrefList.push_back( pan_hidden );
recent_files  = new TvWidget_StringList( NULL, "RECENTS", NULL, app_ref );
PrefList.push_back( recent_files );

save_dlg_geo = new TvWidget_bool( N_("Save dialogs geometry"), "SAVEDGEO", NULL, app_ref, true );
PrefList.push_back( save_dlg_geo );
med_xpos = new TvWidget_int( NULL, "MEDXPOS", NULL, app_ref, 0 );
PrefList.push_back( med_xpos );
med_ypos = new TvWidget_int( NULL, "MEDYPOS", NULL, app_ref, 0 );
PrefList.push_back( med_ypos );
med_xsize = new TvWidget_int( NULL, "MEDXSIZE", NULL, app_ref, 800 );
PrefList.push_back( med_xsize );
med_ysize = new TvWidget_int( NULL, "MEDYSIZE", NULL, app_ref, 600 );
PrefList.push_back( med_ysize );

con_xpos = new TvWidget_int( NULL, "CONXPOS", NULL, app_ref, 150 );
PrefList.push_back( con_xpos );
con_ypos = new TvWidget_int( NULL, "CONYPOS", NULL, app_ref, 150 );
PrefList.push_back( con_ypos );
con_xsize = new TvWidget_int( NULL, "CONXSIZE", NULL, app_ref, 350 );
PrefList.push_back( con_xsize );
con_ysize = new TvWidget_int( NULL, "CONYSIZE", NULL, app_ref, 350 );
PrefList.push_back( con_ysize );

rdlg_xpos = new TvWidget_int( NULL, "RDLGXPOS", NULL, app_ref, 0 );
PrefList.push_back( rdlg_xpos );
rdlg_ypos = new TvWidget_int( NULL, "RDLGYPOS", NULL, app_ref, 0 );
PrefList.push_back( rdlg_ypos );

ropt_xpos = new TvWidget_int( NULL, "ROPTXPOS", NULL, app_ref, 150 );
PrefList.push_back( ropt_xpos );
ropt_ypos = new TvWidget_int( NULL, "ROPTYPOS", NULL, app_ref, 150 );
PrefList.push_back( ropt_ypos );
ropt_xsize = new TvWidget_int( NULL, "ROPTXSIZE", NULL, app_ref, 540 );
PrefList.push_back( ropt_xsize );
ropt_ysize = new TvWidget_int( NULL, "ROPTYSIZE", NULL, app_ref, 400 );
PrefList.push_back( ropt_ysize );

mlib_xpos = new TvWidget_int( NULL, "MLIBXPOS", NULL, app_ref, 25 );
PrefList.push_back( mlib_xpos );
mlib_ypos = new TvWidget_int( NULL, "MLIBYPOS", NULL, app_ref, 25 );
PrefList.push_back( mlib_ypos );
mlib_xsize = new TvWidget_int( NULL, "MLIBXSIZE", NULL, app_ref, 800 );
PrefList.push_back( mlib_xsize );
mlib_ysize = new TvWidget_int( NULL, "MLIBYSIZE", NULL, app_ref, 600 );
PrefList.push_back( mlib_ysize );

tbar_selected  = new TvWidget_color( N_("Focused view bar color"), "TBSCOL", NULL, app_ref );
tbar_selected->set( 0.32, 0.45, 0.69 );
PrefList.push_back( tbar_selected );
tbar_unselected  = new TvWidget_color( N_("Unfocused view bar color"), "TBUSCOL", NULL, app_ref );
tbar_unselected->set( 0.82, 0.82, 0.82 );
PrefList.push_back( tbar_unselected );


// Interface options
tooltips = new TvWidget_bool( N_("Show tooltips"), "TOOLTIPS", _("Show ints on interface controls"), app_ref, true );
PrefList.push_back( tooltips );
toolbar_text = new TvWidget_bool( N_("Show labels in toolbar"), "TBTEXT", _("Display text & icons in toolbar"), app_ref, false );
PrefList.push_back( toolbar_text );
toolbar = new TvWidget_bool( N_("Show toolbar"), "TOOLB", _("Show toolbar"), app_ref, true );
PrefList.push_back( toolbar );
matedit = new TvWidget_bool( N_("Open editor at material creation"), "MATED", NULL, app_ref, false );
PrefList.push_back( matedit );
undo_limit = new TvWidget_int( N_("Maximum undo level"), "UNDOL", NULL, app_ref, 10 );
PrefList.push_back( undo_limit );
display_splash = new TvWidget_bool( N_("Display splash screen at startup"), "SPLASH", NULL, app_ref, true );
PrefList.push_back( display_splash );
auto_obj_edit = new TvWidget_bool( N_("Switch to edition panel at object creation"), "AUTOED", NULL, app_ref, false );
PrefList.push_back( auto_obj_edit );

// Axis & axis labels
axis2D = new TvWidget_bool( N_("Show axis in 2d view"), "AXIS2D", NULL, app_ref, true );
PrefList.push_back( axis2D );
axis3D = new TvWidget_bool( N_("Show axis in 3d view"), "AXIS3D", NULL, app_ref, true );
PrefList.push_back( axis3D );
axis_color = new TvWidget_color( N_("Axis color"), "AXISCOL", NULL, app_ref );
axis_color->set( 0.44, 0.44, 0.44 );
PrefList.push_back( axis_color );
labels2D = new TvWidget_bool( N_("Show axis labels in 2d view"), "LAB2D", NULL, app_ref, true );
PrefList.push_back( labels2D );
labels3D = new TvWidget_bool( N_("Show axis labels in 3d view"), "LAB3D", NULL, app_ref, true );
PrefList.push_back( labels3D );
labels_color = new TvWidget_color( N_("Labels color"), "LABCOL", NULL, app_ref );
labels_color->set( 0.44, 0.44, 0.44 );
PrefList.push_back( labels_color );

// Grids
grid2D = new TvWidget_bool( N_("Show grid in 2d view"), "2DGRID", NULL, app_ref, true );
PrefList.push_back( grid2D );
gridxy = new TvWidget_bool( N_("Show XY grid in 2d view"), "XYGRID", NULL, app_ref, false );
PrefList.push_back( gridxy );
gridxz = new TvWidget_bool( N_("Show XZ grid in 2d view"), "XZGRID", NULL, app_ref, true );
PrefList.push_back( gridxz );
gridyz = new TvWidget_bool( N_("Show YZ grid in 2d view"), "YZGRID", NULL, app_ref, false );
PrefList.push_back( gridyz );
gridxy_color = new TvWidget_color( N_("XY grid color"), "XYGCOL", NULL, app_ref );
gridxy_color->set( 0.52, 0.52, 0.52 );
PrefList.push_back( gridxy_color );
gridxz_color = new TvWidget_color( N_("XZ grid color"), "XZGCOL", NULL, app_ref );
gridxz_color->set( 0.52, 0.52, 0.52 );
PrefList.push_back( gridxz_color );
gridyz_color = new TvWidget_color( N_("YZ grid color"), "XYGCOL", NULL, app_ref );
gridyz_color->set( 0.52, 0.52, 0.52 );
PrefList.push_back( gridyz_color );

// Default view modes
view_modes[0] = new TvWidget_int( NULL, "VIEW0MOD", NULL, app_ref, 0 );
PrefList.push_back( view_modes[0] );
view_modes[1] = new TvWidget_int( NULL, "VIEW1MOD", NULL, app_ref, 1 );
PrefList.push_back( view_modes[1] );
view_modes[2] = new TvWidget_int( NULL, "VIEW2MOD", NULL, app_ref, 2 );
PrefList.push_back( view_modes[2] );
view_modes[3] = new TvWidget_int( NULL, "VIEW3MOD", NULL, app_ref, 3 );
PrefList.push_back( view_modes[3] );

 // Grid and Snap settings
grid_spacing = new TvWidget_float(N_("Grid Spacing"), "GRIDSPACING", _("Spacing between gridpoints"), app_ref, 0.4 );
grid_spacing->set_range( 100.0, 0.01, 0.05, 2 );
PrefList.push_back( grid_spacing );

grid_major_lines = new TvWidget_int( N_("Major grid lines"), "GRIDMAJOR", _("Major grid line every nth point"), app_ref, 10 );
grid_major_lines->set_range(100, 2, 1);
PrefList.push_back( grid_major_lines );

// OpenGL options
line_antialias = new TvWidget_bool( N_("Antialiasing"), "ANTIALIAS", _("Smooth lines"), app_ref, false );
PrefList.push_back( line_antialias );
zoom2d = new TvWidget_bool( N_("Link 2d zoom"), "ZOOM2D", _("Use the same zoom factor for every 2d view"), app_ref, true );
PrefList.push_back( zoom2d );
nav2D = new TvWidget_bool( N_("Link view centers"), "NAV2D", _("Use the same center of interest for every view"), app_ref, true );
PrefList.push_back( nav2D );

// Colors
v3dbkg_color = new TvWidget_color( N_("3d view background color"), "3DBKG", NULL, app_ref );
v3dbkg_color->set( 0.7, 0.7, 0.7 );
PrefList.push_back( v3dbkg_color );
v2dbkg_color = new TvWidget_color( N_("2d view background color"), "2DBKG", NULL, app_ref );
v2dbkg_color->set( 0.7, 0.7, 0.7 );
PrefList.push_back( v2dbkg_color );

obj_color = new TvWidget_color( N_("Unselected object color"), "OBJCOL", NULL, app_ref );
obj_color->set( 0.94, 0.94, 0.94 );
PrefList.push_back( obj_color );
objsel_color = new TvWidget_color( N_("Selected object color"), "OBJSCOL", NULL, app_ref );
objsel_color->set( 0.14, 0.14, 1.00 );
PrefList.push_back( objsel_color );

//  preview quality
blob_preview_quality = new TvWidget_option_combo( N_("Blob preview quality"), "BLOBPQ", NULL, app_ref );
blob_preview_quality->set_list( blob_preview_quality_list, blob_preview_quality_num, 1 );
PrefList.push_back( blob_preview_quality );
preview_quality = new TvWidget_option_combo( N_("Previews quality"), "PREVQ", NULL, app_ref );
preview_quality->set_list( preview_quality_list, preview_quality_num, 1 );
PrefList.push_back( preview_quality );
 
hf_preview_quality = new TvWidget_int(N_("Heightfield preview %"), "HFPREFQ", _("Quality ranges from 10% to 100%"), app_ref, 10 );
hf_preview_quality->set_range( 100, 10, 5 );
PrefList.push_back( hf_preview_quality );
 
// Paths
povcmd = new TvWidget_path( N_("Povray command"), "POVCMD", _("Command used to launch povray or megapov"), app_ref );
povcmd->set( "povray" );
PrefList.push_back( povcmd );
gamma = new TvWidget_float( N_("Gamma"), "GAMMA", NULL, app_ref, 1.0 );
gamma->set_range( 4, 0.1, 0.1 );
PrefList.push_back( gamma );

fonts_path = new TvWidget_path( N_("Default font"), "FONTP", _("Path to look for the default truetype font for text object"), app_ref );
fonts_path->set( "/usr/lib/povray/include/crystal.ttf" );
fonts_path->set_action( GTK_FILE_CHOOSER_ACTION_OPEN  );
PrefList.push_back( fonts_path );

// Page Misc.
author = new TvWidget_entry( N_("Default author name"), "AUTH", N_("Name set by default in author entries"), app_ref );
PrefList.push_back( author );
no_script_exec = new TvWidget_bool( N_("Don't execute pov script objects"), "NOSCRIPT", NULL, app_ref, false );
PrefList.push_back( no_script_exec );

// material preview
save_preview_settings = new TvWidget_bool( N_("Save material editor preview options"), "POSAVE", NULL, app_ref, true );
PrefList.push_back( save_preview_settings );
preview_size = new TvWidget_int( NULL, "PSIZE", NULL, app_ref, 1 );
PrefList.push_back( preview_size );
preview_object  = new TvWidget_int( NULL, "POBJ", NULL, app_ref, 0 );
PrefList.push_back( preview_object );
preview_wall = new TvWidget_bool( NULL, "PWALL", NULL, app_ref, false );
PrefList.push_back( preview_wall );
preview_floor = new TvWidget_bool( NULL, "PFLOOR", NULL, app_ref, true );
PrefList.push_back( preview_floor );
preview_sky = new TvWidget_bool( NULL, "PSKY", NULL, app_ref, false );
PrefList.push_back( preview_sky );
preview_antialias   = new TvWidget_bool( NULL, "PANTIA", NULL, app_ref, true );
PrefList.push_back( preview_antialias );

// Properties panel
edit_page_detached = new TvWidget_bool( NULL, "PPED", NULL, app_ref, false );
select_page_detached = new TvWidget_bool( NULL, "PPSD", NULL, app_ref, false );
create_page_detached = new TvWidget_bool( NULL, "PPCD", NULL, app_ref, false );
material_page_detached = new TvWidget_bool( NULL, "PPMD", NULL, app_ref, false );
PrefList.push_back( edit_page_detached );
PrefList.push_back( select_page_detached );
PrefList.push_back( create_page_detached );
PrefList.push_back( material_page_detached );

ppep_xpos = new TvWidget_int( NULL, "PPEP_XP", NULL, app_ref, 10 );
PrefList.push_back( ppep_xpos );
ppep_ypos = new TvWidget_int( NULL, "PPEP_YP", NULL, app_ref, 10 );
PrefList.push_back( ppep_ypos );
ppep_xsize = new TvWidget_int( NULL, "PPEP_XS", NULL, app_ref, 375 );
PrefList.push_back( ppep_xsize );
ppep_ysize = new TvWidget_int( NULL, "PPEP_YS", NULL, app_ref, 650 );
PrefList.push_back( ppep_ysize );

ppsp_xpos = new TvWidget_int( NULL, "PPSP_XP", NULL, app_ref, 250 );
PrefList.push_back( ppsp_xpos );
ppsp_ypos = new TvWidget_int( NULL, "PPSP_YP", NULL, app_ref, 10 );
PrefList.push_back( ppsp_ypos );
ppsp_xsize = new TvWidget_int( NULL, "PPSP_XS", NULL, app_ref, 375 );
PrefList.push_back( ppsp_xsize );
ppsp_ysize = new TvWidget_int( NULL, "PPSP_YS", NULL, app_ref, 650 );
PrefList.push_back( ppsp_ysize );

ppcp_xpos = new TvWidget_int( NULL, "PPCP_XP", NULL, app_ref, 500 );
PrefList.push_back( ppcp_xpos );
ppcp_ypos = new TvWidget_int( NULL, "PPCP_YP", NULL, app_ref, 10 );
PrefList.push_back( ppcp_ypos );
ppcp_xsize = new TvWidget_int( NULL, "PPCP_XS", NULL, app_ref, 375 );
PrefList.push_back( ppcp_xsize );
ppcp_ysize = new TvWidget_int( NULL, "PPCP_YS", NULL, app_ref, 650 );
PrefList.push_back( ppcp_ysize );

ppmp_xpos = new TvWidget_int( NULL, "PPMP_XP", NULL, app_ref, 750 );
PrefList.push_back( ppmp_xpos );
ppmp_ypos = new TvWidget_int( NULL, "PPMP_YP", NULL, app_ref, 10 );
PrefList.push_back( ppmp_ypos );
ppmp_xsize = new TvWidget_int( NULL, "PPMP_XS", NULL, app_ref, 375 );
PrefList.push_back( ppmp_xsize );
ppmp_ysize = new TvWidget_int( NULL, "PPMP_YS", NULL, app_ref, 650 );
PrefList.push_back( ppmp_ysize );

// Home
const char *home_dir = "/.truevision";
char *home_base = getenv( "HOME" );
home = new char[ strlen(home_base) + strlen( home_dir ) + 1 ];
strcpy( home, home_base );
strcat( home, home_dir );
if ( access( home, F_OK ) == -1 ) mkdir( home, S_IRWXU );


// Preferences file
const char * pref_file_name = "/preferences";
pref_file = new char[ strlen(home) + strlen( pref_file_name ) + 1 ];
strcpy( pref_file, home );
strcat( pref_file, pref_file_name );
load();
}

//***********************************************
// Load
//***********************************************
void Preferences::load()
{
if ( access( pref_file, F_OK ) == -1 ) return;

ifstream file( pref_file, ios::binary );
char *tag = NULL;
do
	{
	tag = tvio_get_next_tag( file );
	if ( tag == NULL ) break;

	bool found = false;
	for ( register unsigned int i = 0 ; i < PrefList.size() ; i++ )
		if ( PrefList[i]->load( file , tag ) ) { found = true; break; }
	if ( found ) continue;

	tvio_skip_section( file );
	}
while( tag != NULL );
return;

file.close();
}


//***********************************************
// Save
//***********************************************
void Preferences::save()
{
// rcup des donnes
((Interface*)(app_ref->interf))->flush_pref();

ofstream file( pref_file, ios::binary );
if ( file == NULL ) { app_warning( _("Cannot create preferences file !" ) ); }
for ( register unsigned int i = 0 ; i < PrefList.size() ; i ++ )
	{
	PrefList[i]->flush();
	PrefList[i]->save( file );
	file << '\n';
	}
file.close();	
}


//**********************************************
// Construction du dialogue
//**********************************************
void Preferences::raise_dlg()
{
if ( GTK_IS_DIALOG(dialog) )
	{
	gdk_window_raise( dialog->window );
	return;
	}
applied = false;

// Sauvegarde pour annulation
for ( register unsigned int i = 0 ; i < PrefList.size() ; i++ )
	PrefList[i]->store();
	
dialog = gtk_dialog_new_with_buttons( _("Preferences"), NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_STOCK_OK, GTK_RESPONSE_OK, GTK_STOCK_APPLY, GTK_RESPONSE_APPLY, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_HELP, GTK_RESPONSE_HELP,NULL );
g_signal_connect( G_OBJECT(dialog), "response", G_CALLBACK(dlg_click), this );
g_signal_connect( G_OBJECT(dialog), "close", G_CALLBACK(dlg_destroy), this );

// Pager
notebk = gtk_notebook_new();
gtk_notebook_set_scrollable( GTK_NOTEBOOK(notebk), TRUE );
gtk_box_pack_start( GTK_BOX(GTK_DIALOG(dialog)->vbox), notebk, FALSE, TRUE, 5 );
GtkWidget *vbox;
GtkWidget *box1, *box2;
bool tt = tooltips->value();

// Page Window
vbox = dlg_new_page( notebk, _("Interface") );
dlg_double_box_frame( _("Main window"), vbox, box1, box2 );
	save_geo->get_widget( box1, tt );
	save_dlg_geo->get_widget( box1, tt );
	tooltips->get_widget( box1, tt );
	toolbar->get_widget( box2, tt );	
	toolbar_text->get_widget( box2, tt );
    undo_limit->get_widget( box1, tt );
    display_splash->get_widget( box1, tt );
	auto_obj_edit->get_widget( box1, tt );

dlg_double_box_frame( _("Material editor"), vbox, box1, box2 );
    matedit->get_widget( box2, tt );
    save_preview_settings	->get_widget( box1, tt );


// Page View
vbox = dlg_new_page( notebk, _("Views") );
dlg_double_box_frame( _("Default axis settings"), vbox, box1, box2 );
	axis2D->get_widget( box1, tt );
	axis3D->get_widget( box1, tt );
	labels3D->get_widget( box1, tt );
	labels2D->get_widget( box1, tt );	
	axis_color->get_widget( box2, tt );
	labels_color->get_widget( box2, tt );

dlg_double_box_frame( _("Default grid settings"), vbox, box1, box2 );
	gridxy->get_widget( box1, tt );
	gridxz->get_widget( box1, tt );
	gridyz->get_widget( box1, tt );
	grid2D->get_widget( box1, tt );
	gridxy_color->get_widget( box2, tt );
	gridxz_color->get_widget( box2, tt );
	gridyz_color->get_widget( box2, tt );
	
dlg_double_box_frame( _("Title bar colors"), vbox, box1, box2 );
	tbar_selected->get_widget( box1, tt );
	tbar_unselected->get_widget( box2, tt );

dlg_double_box_frame( _("Misc."), vbox, box1, box2 );
	v2dbkg_color->get_widget( box1, tt );
	v3dbkg_color->get_widget( box1, tt );
	obj_color->get_widget( box1, tt );
	objsel_color->get_widget( box1, tt );
	line_antialias->get_widget( box2, tt );
	zoom2d->get_widget( box2, tt );
	nav2D->get_widget( box2, tt );
	preview_quality->get_widget( box2, tt );
	blob_preview_quality->get_widget( box2, tt );
	hf_preview_quality->get_widget( box2, tt );
 // Grid and Snap-Settings
vbox = dlg_new_page( notebk, _("Grid and Snap ") );
dlg_double_box_frame( _("Grid Spacing"), vbox, box1, box2 );
    grid_spacing->get_widget( box1, tt );
    grid_major_lines->get_widget( box1, tt );

// Page Povray
vbox = dlg_new_page( notebk, _("Povray") );
dlg_double_box_frame( _("Options"), vbox, box1, box2 );
	povcmd->get_widget( box1, tt );
	fonts_path->get_widget( box1, tt );
	gamma ->get_widget( box1, tt );

// Page Misc
vbox = dlg_new_page( notebk, _("Misc.") );
dlg_double_box_frame( _("Identity"), vbox, box1, box2 );
	author->get_widget( box1, tt );

dlg_double_box_frame( _("Security"), vbox, box1, box2 );
	no_script_exec->get_widget( box1, tt );

gtk_widget_show_all(dialog);
gtk_notebook_set_page( GTK_NOTEBOOK(notebk), selected_page );
}


// Rsultat
void Preferences::clicked( gint button )
{
switch( button )
	{
	case GTK_RESPONSE_OK:
		//cout << "\nPoint 1"; cout.flush();
		flush_dlg();
		//cout << "\nPoint 2"; cout.flush();
		close_dlg();
		//cout << "\nPoint 3"; cout.flush();
		send_message();
		//cout << "\nPoint 4"; cout.flush();
		break;

	case GTK_RESPONSE_APPLY:
		flush_dlg();
		send_message();
		applied = true;
		break;

	case GTK_RESPONSE_HELP:
		{
		int sel = gtk_notebook_get_current_page( GTK_NOTEBOOK(notebk) ) + 1;
		if ( sel == 1 ) truevision_help_display( "truevision.xml",  "sect-gui-prefs1", NULL );		
		if ( sel == 2 ) truevision_help_display( "truevision.xml",  "sect-gui-prefs2", NULL );		
		if ( sel == 3 ) truevision_help_display( "truevision.xml",  "sect-gui-prefs3", NULL );		
		if ( sel == 4 ) truevision_help_display( "truevision.xml",  "sect-gui-prefs4", NULL );		
		}
		break;

	default:
	case GTK_RESPONSE_CANCEL:
		if ( applied ) { undo_dlg(); send_message(); }
		close_dlg();
		break;
	}
}

//***********************************************************
// Message
//***********************************************************
void Preferences::send_message()
{
//cout << "\nPref changed for interface !"; cout.flush();
app_ref->interf->pref_changed();
//cout << "\nPref changed for toolbar !"; cout.flush();
//app_ref->toolbar->pref_changed();
//cout << "\nPref changed for objlist !"; cout.flush();
app_ref->obj3dlist->pref_changed();
//cout << "\nPref changed for view manager !"; cout.flush();
app_ref->vmanager->pref_changed();
//cout << "\nPref changed for scene !"; cout.flush();
app_ref->scene->pref_changed();
//cout << "\nPref changed for texlist !"; cout.flush();
app_ref->matlist->pref_changed();
app_ref->proppanel->pref_changed();
//cout << "\nPref changed for me !"; cout.flush();
pref_changed();  // Me, too ;-)
//cout << "\nDone !"; cout.flush();
}

void Preferences::close_dlg()
{
selected_page = gtk_notebook_get_current_page( GTK_NOTEBOOK(notebk) );
if ( GTK_IS_DIALOG(dialog) ) gtk_widget_destroy( dialog );
dialog = NULL;
for ( register unsigned int i = 0 ; i < PrefList.size()  ; i++ )
	PrefList[i]->clear_widget();
}
