//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// proppanel.cc
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2005 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 
//*******************************************************************************************
#include "include/proppanel.h"
#include "include/objectlist.h"
#include "include/matlist.h"
#include "include/interface.h"
#include "include/preferences.h"

const char *proppanel_buttons_icons[PROPPANEL_MAX_PAGE] = 
	{ GTK_STOCK_EDIT, GTK_STOCK_INDEX, GTK_STOCK_NEW, GTK_STOCK_SELECT_COLOR };

const char *pages_labels[PROPPANEL_MAX_PAGE] = 
	{ _("Edit"), _("Select"), _("Create"), _("Materials") };

const guint pages_accels[PROPPANEL_MAX_PAGE] = 
	{ GDK_F5, GDK_F6, GDK_F7, GDK_F8 };
	
	
//***************************************************
// Constructeur
//***************************************************
PropPanel::PropPanel( app_objs *appref, GtkWidget *box )
{
app_ref = appref;
app_ref->proppanel = this;
OBJLIST_DEF 
MATLIST_DEF
PREF_DEF
	
pages_detach_state[0] = pref->edit_page_detached->value();
pages_detach_state[1] = pref->select_page_detached->value();
pages_detach_state[2] = pref->create_page_detached->value();
pages_detach_state[3] = pref->material_page_detached->value();
	
notebook = gtk_notebook_new();
gtk_widget_set_usize( notebook, 257, -1 );
gtk_notebook_set_scrollable( GTK_NOTEBOOK(notebook), TRUE );
gtk_box_pack_start( GTK_BOX(box), notebook, TRUE, TRUE, 4 );

objlist->set_edit_widget( create_notebook_page(0) );
objlist->set_select_widget( create_notebook_page(1) );
objlist->set_create_widget( create_notebook_page(2) );
matlist->set_select_widget( create_notebook_page(3) );

}

PropPanel::~PropPanel()
{
PREF_DEF	

if ( pref->save_dlg_geo->value() )
		{
		if ( pages_detach_state[0] == TRUE )
			{	
			gint x,y;
			gdk_window_get_root_origin( pages_window[0]->window, &x, &y );
			pref->ppep_xpos->set( x );
			pref->ppep_ypos->set( y );
			pref->ppep_xsize->set( pages_window[0]->allocation.width );
			pref->ppep_ysize->set( pages_window[0]->allocation.height );
			}
			
		if ( pages_detach_state[1] == TRUE )
			{	
			gint x,y;
			gdk_window_get_root_origin( pages_window[1]->window, &x, &y );
			pref->ppsp_xpos->set( x );
			pref->ppsp_ypos->set( y );
			pref->ppsp_xsize->set( pages_window[1]->allocation.width );
			pref->ppsp_ysize->set( pages_window[1]->allocation.height );
			}

		if ( pages_detach_state[2] == TRUE )
			{	
			gint x,y;
			gdk_window_get_root_origin( pages_window[2]->window, &x, &y );
			pref->ppcp_xpos->set( x );
			pref->ppcp_ypos->set( y );
			pref->ppcp_xsize->set( pages_window[2]->allocation.width );
			pref->ppcp_ysize->set( pages_window[2]->allocation.height );
			}
			
		if ( pages_detach_state[3] == TRUE )
			{	
			gint x,y;
			gdk_window_get_root_origin( pages_window[3]->window, &x, &y );
			pref->ppmp_xpos->set( x );
			pref->ppmp_ypos->set( y );
			pref->ppmp_xsize->set( pages_window[3]->allocation.width );
			pref->ppmp_ysize->set( pages_window[3]->allocation.height );
			}		
		}
			
pref->edit_page_detached->set( pages_detach_state[0] );
pref->select_page_detached->set( pages_detach_state[1] );
pref->create_page_detached->set( pages_detach_state[2] );
pref->material_page_detached->set( pages_detach_state[3] );
}


//*****************************************************
// New Page
//*****************************************************
GtkWidget *PropPanel::create_notebook_page( int page_num )
{
// Keyboard shortcuts
INTERF_DEF
PREF_DEF

// Page data container
GtkWidget *vbox = gtk_vbox_new( FALSE, 0 );
page_containers[page_num] = gtk_vbox_new( FALSE, 0 );
gtk_container_set_border_width( GTK_CONTAINER(vbox), 2 );
gtk_box_pack_end( GTK_BOX(vbox), page_containers[page_num], TRUE, TRUE, 1 );

if ( pages_detach_state[page_num] == FALSE )
	{		
	// Create a new page in the notebook
	// Notebook label button & tootips
	label_button[page_num] = gtk_button_new();
		gtk_signal_connect( GTK_OBJECT(label_button[page_num]), "clicked", GTK_SIGNAL_FUNC(sign_proppanel_clicked), this );
		GtkWidget *pix = gtk_image_new_from_stock( proppanel_buttons_icons[page_num], GTK_ICON_SIZE_BUTTON );
		gtk_container_add( GTK_CONTAINER( label_button[page_num]), pix );
		gtk_widget_show_all( label_button[page_num] );
		
		proppanel_tooltips[page_num] = gtk_tooltips_new();
		gtk_tooltips_set_tip( proppanel_tooltips[page_num], label_button[page_num], pages_labels[page_num], NULL );
		if ( !pref->tooltips->value() ) gtk_tooltips_disable( proppanel_tooltips[page_num] );
		gtk_button_set_relief( GTK_BUTTON(label_button[page_num]), GTK_RELIEF_NONE );
		GTK_WIDGET_UNSET_FLAGS( label_button[page_num], GTK_CAN_FOCUS );	
		gtk_widget_add_accelerator( label_button[page_num], "clicked", interf->get_accels(), pages_accels[page_num], (GdkModifierType)0, (GtkAccelFlags)0 );
		
	// Detacher button
	GtkWidget *hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX(vbox), hbox, FALSE, TRUE, 1 );
	detach_buttons[page_num] = gtk_button_new();
	gtk_button_set_relief( GTK_BUTTON(detach_buttons[page_num]), GTK_RELIEF_NONE );
	GTK_WIDGET_UNSET_FLAGS( detach_buttons[page_num], GTK_CAN_FOCUS );	
	gtk_box_pack_end( GTK_BOX(hbox), detach_buttons[page_num], FALSE, FALSE, 1 );
	gtk_signal_connect( GTK_OBJECT(detach_buttons[page_num]), "clicked", GTK_SIGNAL_FUNC(sign_proppanel_detach), this );
	char *pname = tv_get_pixmap( "page_detach.png" );
	pix = gtk_image_new_from_file( pname );
	gtk_container_add( GTK_CONTAINER( detach_buttons[page_num]), pix );
	gtk_container_set_border_width( GTK_CONTAINER( detach_buttons[page_num]), 0 );
		
	gtk_notebook_append_page( GTK_NOTEBOOK(notebook), vbox, label_button[page_num]  );
	pages_window[page_num] = NULL;
	delete pname;
	}
else
	{
	// Create a new window
// Detach
	pages_window[page_num] = gtk_window_new( GTK_WINDOW_TOPLEVEL );
	gtk_signal_connect( GTK_OBJECT(pages_window[page_num]), "delete_event", GTK_SIGNAL_FUNC(sign_proppanel_attach), this );
	gtk_signal_connect( GTK_OBJECT(pages_window[page_num]), "destroy", GTK_SIGNAL_FUNC(sign_proppanel_attach2), this );
	gtk_window_set_title( GTK_WINDOW(pages_window[page_num]), pages_labels[page_num] );
	gtk_container_add(  GTK_CONTAINER(pages_window[page_num]), vbox );
		
	if ( pref->save_dlg_geo->value() )
		{
		switch( page_num )
			{
			case 0:
				gtk_widget_set_uposition( pages_window[page_num], pref->ppep_xpos->value(), pref->ppep_ypos->value() );
				gtk_window_set_default_size( GTK_WINDOW(pages_window[page_num]), pref->ppep_xsize->value(), pref->ppep_ysize->value() );
				break;
			case 1:
				gtk_widget_set_uposition( pages_window[page_num], pref->ppsp_xpos->value(), pref->ppsp_ypos->value() );
				gtk_window_set_default_size( GTK_WINDOW(pages_window[page_num]), pref->ppsp_xsize->value(), pref->ppsp_ysize->value() );
				break;
			case 2:
				gtk_widget_set_uposition( pages_window[page_num], pref->ppcp_xpos->value(), pref->ppcp_ypos->value() );
				gtk_window_set_default_size( GTK_WINDOW(pages_window[page_num]), pref->ppcp_xsize->value(), pref->ppcp_ysize->value() );
				break;
			case 3:
				gtk_widget_set_uposition( pages_window[page_num], pref->ppmp_xpos->value(), pref->ppmp_ypos->value() );
				gtk_window_set_default_size( GTK_WINDOW(pages_window[page_num]), pref->ppmp_xsize->value(), pref->ppmp_ysize->value() );
				break;
			}
		}
	gtk_widget_show_all( pages_window[page_num] );
			
	label_button[page_num] = NULL;
	}
	
return page_containers[page_num];;
}


void PropPanel::label_clicked( GtkWidget *wid )
{
int i;
int page_num = 0;
for (  i = 0 ; i < PROPPANEL_MAX_PAGE ; i++ )
	{
	if ( label_button[i] == wid ) break;
	if ( label_button[i]  != NULL ) page_num++;
	}
set_page( page_num );
}


void PropPanel::pref_changed()
{
PREF_DEF

for (  int i = 0 ; i < PROPPANEL_MAX_PAGE-1 ; i++ )
	if ( pages_detach_state[i] == FALSE )
		{
		if ( !pref->tooltips->value() ) gtk_tooltips_disable( proppanel_tooltips[i] );
		else gtk_tooltips_enable( proppanel_tooltips[i] );
		}
}



void PropPanel::detach( GtkWidget *wid )
{
PREF_DEF
int page_num = 0;
for ( page_num = 0 ; page_num < PROPPANEL_MAX_PAGE ; page_num++ )
	if ( wid == detach_buttons[page_num] ) break;

if ( pages_detach_state[page_num] != FALSE ) return;

// Detach
pages_window[page_num] = gtk_window_new( GTK_WINDOW_TOPLEVEL );
gtk_signal_connect( GTK_OBJECT(pages_window[page_num]), "delete_event", GTK_SIGNAL_FUNC(sign_proppanel_attach), this );
gtk_signal_connect( GTK_OBJECT(pages_window[page_num]), "destroy", GTK_SIGNAL_FUNC(sign_proppanel_attach2), this );
gtk_window_set_title( GTK_WINDOW(pages_window[page_num]), pages_labels[page_num] );
gtk_widget_reparent( page_containers[page_num], pages_window[page_num] );

if ( pref->save_dlg_geo->value() )
		{
		switch( page_num )
			{
			case 0:
				gtk_widget_set_uposition( pages_window[page_num], pref->ppep_xpos->value(), pref->ppep_ypos->value() );
				gtk_window_set_default_size( GTK_WINDOW(pages_window[page_num]), pref->ppep_xsize->value(), pref->ppep_ysize->value() );
				break;
			case 1:
				gtk_widget_set_uposition( pages_window[page_num], pref->ppsp_xpos->value(), pref->ppsp_ypos->value() );
				gtk_window_set_default_size( GTK_WINDOW(pages_window[page_num]), pref->ppsp_xsize->value(), pref->ppsp_ysize->value() );
				break;
			case 2:
				gtk_widget_set_uposition( pages_window[page_num], pref->ppcp_xpos->value(), pref->ppcp_ypos->value() );
				gtk_window_set_default_size( GTK_WINDOW(pages_window[page_num]), pref->ppcp_xsize->value(), pref->ppcp_ysize->value() );
				break;
			case 3:
				gtk_widget_set_uposition( pages_window[page_num], pref->ppmp_xpos->value(), pref->ppmp_ypos->value() );
				gtk_window_set_default_size( GTK_WINDOW(pages_window[page_num]), pref->ppmp_xsize->value(), pref->ppmp_ysize->value() );
				break;
			}
		}
gtk_widget_show_all( pages_window[page_num] );

int nb_page = page_num;
for ( int i = 0 ; i < page_num ; i++ )
	if ( pages_detach_state[i] ) nb_page--;
gtk_notebook_remove_page( GTK_NOTEBOOK(notebook), nb_page );
label_button[page_num] = NULL;
pages_detach_state[page_num] = TRUE;
}


void PropPanel::attach( GtkWidget *wid )
{
PREF_DEF	
INTERF_DEF
	
int page_num = 0;
for ( page_num = 0 ; page_num < PROPPANEL_MAX_PAGE ; page_num++ )
	if ( wid == pages_window[page_num] ) break;
		
int nb_page = page_num;
for ( int i = 0 ; i < page_num ; i++ )
	if ( pages_detach_state[i] ) nb_page--;

GtkWidget *vbox = gtk_vbox_new( FALSE, 0 );
gtk_container_set_border_width( GTK_CONTAINER(vbox), 2 );
	
// Detacher button
GtkWidget *hbox = gtk_hbox_new( FALSE, 0 );
gtk_box_pack_start( GTK_BOX(vbox), hbox, FALSE, TRUE, 1 );
detach_buttons[page_num] = gtk_button_new();
gtk_button_set_relief( GTK_BUTTON(detach_buttons[page_num]), GTK_RELIEF_NONE );
GTK_WIDGET_UNSET_FLAGS( detach_buttons[page_num], GTK_CAN_FOCUS );	
gtk_box_pack_end( GTK_BOX(hbox), detach_buttons[page_num], FALSE, FALSE, 1 );
gtk_signal_connect( GTK_OBJECT(detach_buttons[page_num]), "clicked", GTK_SIGNAL_FUNC(sign_proppanel_detach), this );
char *pname = tv_get_pixmap( "page_detach.png" );
GtkWidget *pix = gtk_image_new_from_file( pname );
gtk_container_add( GTK_CONTAINER( detach_buttons[page_num]), pix );	

// Save detached window geometry if possible	
if ( pref->save_dlg_geo->value() )
		{
		switch( page_num )
			{
			case 0:
				{	
				if ( GDK_IS_WINDOW(pages_window[page_num]->window) ) 
					{
					gint x,y;
					gdk_window_get_root_origin( pages_window[page_num]->window, &x, &y );
					pref->ppep_xpos->set( x );
					pref->ppep_ypos->set( y );
					pref->ppep_xsize->set( pages_window[page_num]->allocation.width );
					pref->ppep_ysize->set( pages_window[page_num]->allocation.height );
					}
				break;
				}
			case 1:
				{	
				if ( GDK_IS_WINDOW(pages_window[page_num]->window) ) 
					{
					gint x,y;
					gdk_window_get_root_origin( pages_window[page_num]->window, &x, &y );
					pref->ppsp_xpos->set( x );
					pref->ppsp_ypos->set( y );
					pref->ppsp_xsize->set( pages_window[page_num]->allocation.width );
					pref->ppsp_ysize->set( pages_window[page_num]->allocation.height );
					}
				break;
				}
			case 2:
				{	
				if ( GDK_IS_WINDOW(pages_window[page_num]->window) ) 
					{
					gint x,y;
					gdk_window_get_root_origin( pages_window[page_num]->window, &x, &y );
					pref->ppcp_xpos->set( x );
					pref->ppcp_ypos->set( y );
					pref->ppcp_xsize->set( pages_window[page_num]->allocation.width );
					pref->ppcp_ysize->set( pages_window[page_num]->allocation.height );
					}
				break;
				}
			case 3:
				{	
				if ( GDK_IS_WINDOW(pages_window[page_num]->window) ) 
					{
					gint x,y;
					gdk_window_get_root_origin( pages_window[page_num]->window, &x, &y );
					pref->ppmp_xpos->set( x );
					pref->ppmp_ypos->set( y );
					pref->ppmp_xsize->set( pages_window[page_num]->allocation.width );
					pref->ppmp_ysize->set( pages_window[page_num]->allocation.height );
					}
				break;
				}			
			}
		}

gtk_widget_reparent( page_containers[page_num], vbox );
		
// Notebook label button & tootips
	label_button[page_num] = gtk_button_new();
		gtk_signal_connect( GTK_OBJECT(label_button[page_num]), "clicked", GTK_SIGNAL_FUNC(sign_proppanel_clicked), this );
		pix = gtk_image_new_from_stock( proppanel_buttons_icons[page_num], GTK_ICON_SIZE_BUTTON );
		gtk_container_add( GTK_CONTAINER( label_button[page_num]), pix );
		gtk_widget_show_all( label_button[page_num] );
		proppanel_tooltips[page_num] = gtk_tooltips_new();
		gtk_tooltips_set_tip( proppanel_tooltips[page_num], label_button[page_num], pages_labels[page_num], NULL );
		if ( !pref->tooltips->value() ) gtk_tooltips_disable( proppanel_tooltips[page_num] );
		GTK_WIDGET_UNSET_FLAGS( label_button[page_num], GTK_CAN_FOCUS );	
		gtk_button_set_relief( GTK_BUTTON(label_button[page_num]), GTK_RELIEF_NONE );
		gtk_widget_add_accelerator( label_button[page_num], "clicked", interf->get_accels(), pages_accels[page_num], (GdkModifierType)0, (GtkAccelFlags)0 );
		
	
	gtk_notebook_insert_page( GTK_NOTEBOOK(notebook), vbox, label_button[page_num], nb_page  );
	gtk_widget_show_all( vbox );
		
gtk_widget_destroy( pages_window[page_num] );
pages_detach_state[page_num] = FALSE;
}
