//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// pyscriptdb.cc
//
// Christian SPOER <spoer@users.sourceforge.net>
// Copyright (C) 2000-2001 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 
//*******************************************************************************************

#include "include/pyscriptdb.h"
#include "include/pyengine.h"
#include "include/dlgutils.h"
#include <sys/dir.h>

PyScriptDB::PyScriptDB( app_objs *appref )
{
	app_ref = appref;
	app_ref->pyscript_db = this;
	py_script_list = new vector<PyScript*>;
}

PyScriptDB::~PyScriptDB()
{
	delete py_script_list;
}

void
PyScriptDB::register_script(PyScript* ps)
{
	if( ps != NULL ) {
		ps->set_pyengine( (PyEngine*)app_ref->python_engine );
		py_script_list->push_back( ps );
//		ps->get_menu_entry();
	}
}

void
PyScriptDB::scan_directory( char* directory_name )
{
	DIR *dp;
	struct dirent *dir;
	char sname[256];
	PyEngine *pe = (PyEngine*)app_ref->python_engine;
	
	if ((dp = opendir(directory_name)) == NULL) {
		printf("Cannot open directory: %s.\n", directory_name);
		return;
	}

	while ((dir = readdir(dp)) != NULL) {
		if(dir->d_ino == 0)
			continue;
		
		if ( ends_with(dir->d_name, ".py") == 1 ) {
			sprintf(sname,"%s/%s", directory_name, dir->d_name);
			pe->execute_script( sname, NULL, 0 );
		}
	}
	closedir(dp);
}

void
PyScriptDB::create_menu_structure( GtkUIManager *ui_manager )
{
	vector<char*>::iterator itMlist;
	vector<char*> *Mlist;
	PyScript *ps;
	
	GtkMenuItem *ssmenu = GTK_MENU_ITEM( gtk_ui_manager_get_widget (ui_manager, "/MainMenu/ScriptMenu") );
	GtkMenu *smenu = GTK_MENU( gtk_menu_item_get_submenu(ssmenu) );
	GtkWidget* entr;
	
	vector<PyScript*>::iterator itPs;
	for ( itPs = py_script_list->begin() ; itPs != py_script_list->end() ; itPs++ ) {
		ps = (PyScript*)(*itPs);
		Mlist = (*itPs)->split_menu_path();
		if( Mlist->size() < 2 )
			continue;
	
		//printf("Adding: %s\n",(char*)((Mlist->back())));fflush(stdout);
		entr = gtk_menu_item_new_with_label( Mlist->back() );
		gtk_signal_connect( GTK_OBJECT(entr), "activate", GTK_SIGNAL_FUNC(sign_run_script_from_menu), ps );
		gtk_menu_append( smenu,  entr );
	}
	gtk_widget_show_all( (GtkWidget*)smenu );
}



////////////////////////////////////////////
// PyScript
////////////////////////////////////////////


PyScript::PyScript()
{
	_script_path = NULL;
	_description = NULL;
	_help_message = NULL;
	_author = NULL;
	_copyright = NULL;
	_year = NULL;
	_object_types = NULL;
	_menupath = NULL;
}

PyScript::~PyScript()
{
	if( _script_path != NULL)
		g_free(_script_path);

	if( _description  != NULL)
		g_free( _description );
	
	if( _help_message != NULL)
		g_free( _help_message );
	
	if( _author != NULL)
		g_free( _author );

	if( _copyright != NULL)
		g_free( _copyright );

	if(	_year != NULL)
		g_free(	_year );

	if( _object_types != NULL)
		g_free( _object_types );

	if( _menupath != NULL)
		g_free( _menupath );
}

vector<char*>*
PyScript::split_menu_path()
{
	vector<char*>* menu_list = new vector<char*>;
	char* mentry = (char*)malloc(strlen(_menupath));
	int i, k;
	k = 0;
	for( i = 0 ; i < strlen(_menupath) ; i++ ) {
		if ( _menupath[i] != '/' ) {
			mentry[k++] = _menupath[i];
		} else {
			mentry[k] = '\0';
			menu_list->push_back( strdup( mentry ) );
			k = 0;
		}
	}
	if( k > 0 ) {
		mentry[k] = '\0';
		menu_list->push_back( strdup( mentry ) );
	}

	_top_level_menu = (char*)*(menu_list->begin());
	g_free( mentry );
	return menu_list;
}

void
PyScript::execute()
{
	_my_pyengine->execute_script( _script_path, NULL, 1);
}

void
PyScript::show_script_info()
{
/*	GtkWidget *dialog;

	dialog = gtk_message_dialog_new (GTK_WINDOW (window),
									 GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
									 GTK_MESSAGE_INFO,
									 GTK_BUTTONS_OK,
									 "%s\n"
									 "(c)Copyright:");
	gtk_message_dialog_format_secondary_text (GTK_MESSAGE_DIALOG (dialog),
											  "%d", );
	gtk_dialog_run (GTK_DIALOG (dialog));
	gtk_widget_destroy (dialog);
*/
}

