//*****************************************************************************************
// Truevision - a 3d modeler for gnome and povray
//
// tvio.cc
//
// Vincent LE PRINCE <vincentleprince@users.sourceforge.net>
// Copyright (C) 2000-2001 Vincent LE PRINCE
// This file is part of the TRUEVISION Package

//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 
//*******************************************************************************************
#include "include/tvio.h"
#include "include/main.h"
#include "config.h"
#include <GL/gl.h>
#include "math.h"

char line[256];
char tag[MAX_TAG_SIZE];

bool tvio_check_file_sig( ifstream & file, char *sig )
{
file.getline( line, 255 );
return( ! strcmp( line, sig ) );
}

char * tvio_get_soft_version( ifstream & file )
{
file.getline( line, 255 );
return NULL;
}

char *tvio_get_next_tag( ifstream & file )
{
int ch = 25;
int i = 1;
while( true )
	{
	ch = file.get();
	if ( ch == EOF || (char)ch == '}' ) return NULL;
	if ( (char)ch == '{' ) break;
	if ( (char)ch == ' ' || (char)ch == '\n' || (char)ch == '\t' || (char)ch == '{' ) i = 0;
	i++;
	}
if ( i > MAX_TAG_SIZE ) { app_warning( _("Bad file format !") ); return NULL; }
file.seekg( - i , ios::cur );
file.read( tag, i );
tag[i-1] = '\0';
//cout << "\nTag seeking string (" << i << "): " << tag << " and ch = " << (int)ch;
return tag;
}

char *tvio_get_next_val( ifstream & file )
{
int ch = 25;
int i = 1;
while( true )
	{
	ch = file.get();
	if ( ch == EOF || (char)ch == '}' ) return NULL;
	if ( (char)ch == '=' ) break;
	if ( (char)ch == ' ' || (char)ch == '\n' || (char)ch == '\t' || (char)ch == '{' ) i = 0;
	i++;
	}
if ( i > MAX_TAG_SIZE ) { app_warning( _("Bad file format !") ); return NULL; }
file.seekg( - i , ios::cur );
file.read( tag, i );
tag[i-1] = '\0';
//cout << "\nVal seeking string (" << i << "): " << tag;
return tag;
}


char *tvio_get_value_as_string( ifstream & file )
{
file.get();
int ch = file.get();
int i = 0;
while ( (char)ch != '"' && ch != EOF )
	{
	line[i++] = (char)ch;
	if ( i > 253 ) break;
	ch = file.get();
	}
line[i] = '\0';
return line;
}


float tvio_get_value_as_float( ifstream & file )
{
float res;
char ch = file.get();
int i = 0;
while ( ch != ' ' && ch != '}' )
	{
	line[i++] = ch;
	if ( i > 253 ) break;
	ch = file.get();
	}
line[i] = '\0';
file.seekg( -1, ios::cur );
sscanf( line, "%f", &res );
//cout << "\nValue is : " << res << " from str -> " << line;
return res;
}

int tvio_get_value_as_int( ifstream & file )
{
int res;
char ch = file.get();
int i = 0;
while ( ch != ' ' && ch != '}' )
	{
	line[i++] = ch;
	if ( i > 253 ) break;
	ch = file.get();
	}
line[i] = '\0';
file.seekg( -1, ios::cur );
sscanf( line, "%i", &res );
//cout << "\nValue is : " << res << " from str -> " << line;
return res;
}

bool tvio_get_value_as_bool( ifstream & file )
{
int res;
char ch = file.get();
//ch = file.get();
res = ( ch == 'Y' ) ? true : false;
//cout << "\nValue is : " << res << " from str -> " << ch;
return res;
}


bool  tvio_skip_section( ifstream & file )
{
int ch;
int i = 0;
while( true )
	{
	ch = file.get();
	if ( ch == EOF ) return false;
	if ( (char)ch == '{' ) i++;
	if ( (char)ch == '}' ) if ( i == 0 ) return true; else i--;
	}
}
