/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.xsom.impl.parser;

import com.sun.xml.xsom.XSDeclaration;
import com.sun.xml.xsom.impl.ForeignAttributesImpl;
import com.sun.xml.xsom.impl.SchemaImpl;
import com.sun.xml.xsom.impl.UName;
import com.sun.xml.xsom.impl.parser.DefaultAnnotationParser;
import com.sun.xml.xsom.impl.parser.Messages;
import com.sun.xml.xsom.impl.parser.ParserContext;
import com.sun.xml.xsom.impl.parser.Patch;
import com.sun.xml.xsom.impl.parser.PatcherManager;
import com.sun.xml.xsom.impl.parser.state.NGCCRuntime;
import com.sun.xml.xsom.impl.parser.state.Schema;
import com.sun.xml.xsom.impl.util.Uri;
import com.sun.xml.xsom.parser.AnnotationParser;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Stack;
import org.relaxng.datatype.ValidationContext;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public class NGCCRuntimeEx
extends NGCCRuntime
implements PatcherManager {
    public final ParserContext parser;
    public SchemaImpl currentSchema;
    public int finalDefault = 0;
    public int blockDefault = 0;
    public boolean elementFormDefault = false;
    public boolean attributeFormDefault = false;
    public boolean chameleonMode = false;
    private String documentSystemId;
    private final Stack elementNames = new Stack();
    private Context currentContext = null;
    public static final String XMLSchemaNSURI = "http://www.w3.org/2001/XMLSchema";

    NGCCRuntimeEx(ParserContext _parser) {
        this(_parser, false);
    }

    private NGCCRuntimeEx(ParserContext _parser, boolean chameleonMode) {
        this.parser = _parser;
        this.chameleonMode = chameleonMode;
        this.currentContext = new Context("", "", null);
        this.currentContext = new Context("xml", "http://www.w3.org/XML/1998/namespace", this.currentContext);
    }

    public void checkDoubleDefError(XSDeclaration c) throws SAXException {
        if (c == null) {
            return;
        }
        this.reportError(Messages.format("DoubleDefinition", c.getName()));
        this.reportError(Messages.format("DoubleDefinition.Original"), c.getLocator());
    }

    public void addPatcher(Patch patcher) {
        this.parser.patcherManager.addPatcher(patcher);
    }

    public void reportError(String msg, Locator loc) throws SAXException {
        this.parser.patcherManager.reportError(msg, loc);
    }

    public void reportError(String msg) throws SAXException {
        this.reportError(msg, this.getLocator());
    }

    private InputSource resolveRelativeURL(String namespaceURI, String relativeUri) throws SAXException {
        String baseUri = this.getLocator().getSystemId();
        if (baseUri == null) {
            baseUri = this.documentSystemId;
        }
        String systemId = Uri.resolve(baseUri, relativeUri);
        EntityResolver er = this.parser.getEntityResolver();
        if (er != null) {
            try {
                InputSource is = er.resolveEntity(namespaceURI, systemId);
                if (is != null) {
                    return is;
                }
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }
        return new InputSource(systemId);
    }

    public void includeSchema(String schemaLocation) throws SAXException {
        NGCCRuntimeEx runtime = new NGCCRuntimeEx(this.parser, this.chameleonMode);
        runtime.currentSchema = this.currentSchema;
        runtime.blockDefault = this.blockDefault;
        runtime.finalDefault = this.finalDefault;
        if (schemaLocation == null) {
            SAXParseException e = new SAXParseException(Messages.format("MissingSchemaLocation"), this.getLocator());
            this.parser.errorHandler.fatalError(e);
            throw e;
        }
        runtime.parseEntity(this.resolveRelativeURL(null, schemaLocation), true, this.currentSchema.getTargetNamespace(), this.getLocator());
    }

    public void importSchema(String ns, String schemaLocation) throws SAXException {
        if (schemaLocation == null) {
            return;
        }
        NGCCRuntimeEx newRuntime = new NGCCRuntimeEx(this.parser);
        newRuntime.parseEntity(this.resolveRelativeURL(ns, schemaLocation), false, ns, this.getLocator());
    }

    public boolean hasAlreadyBeenRead(String targetNamespace) {
        ParserContext.DocumentIdentity docIdentity;
        if (this.documentSystemId == null) {
            return false;
        }
        if (this.documentSystemId.startsWith("file:///")) {
            this.documentSystemId = "file:/" + this.documentSystemId.substring(8);
        }
        return !this.parser.parsedDocuments.add(docIdentity = new ParserContext.DocumentIdentity(targetNamespace, this.documentSystemId));
    }

    public void parseEntity(InputSource source, boolean includeMode, String expectedNamespace, Locator importLocation) throws SAXException {
        this.documentSystemId = source.getSystemId();
        try {
            Schema s = new Schema(this, includeMode, expectedNamespace);
            this.setRootHandler(s);
            try {
                this.parser.parser.parse(source, this, this.getErrorHandler(), this.parser.getEntityResolver());
            }
            catch (IOException e) {
                SAXParseException se = new SAXParseException(e.toString(), importLocation, e);
                this.parser.errorHandler.fatalError(se);
                throw se;
            }
        }
        catch (SAXException e) {
            this.parser.setErrorFlag();
            throw e;
        }
    }

    public AnnotationParser createAnnotationParser() {
        if (this.parser.getAnnotationParserFactory() == null) {
            return DefaultAnnotationParser.theInstance;
        }
        return this.parser.getAnnotationParserFactory().create();
    }

    public String getAnnotationContextElementName() {
        return (String)this.elementNames.get(this.elementNames.size() - 2);
    }

    public Locator copyLocator() {
        return new LocatorImpl(this.getLocator());
    }

    public ErrorHandler getErrorHandler() {
        return this.parser.errorHandler;
    }

    public void onEnterElementConsumed(String uri, String localName, String qname2, Attributes atts) throws SAXException {
        super.onEnterElementConsumed(uri, localName, qname2, atts);
        this.elementNames.push(localName);
    }

    public void onLeaveElementConsumed(String uri, String localName, String qname2) throws SAXException {
        super.onLeaveElementConsumed(uri, localName, qname2);
        this.elementNames.pop();
    }

    public ValidationContext createValidationContext() {
        return this.currentContext;
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        super.startPrefixMapping(prefix, uri);
        this.currentContext = new Context(prefix, uri, this.currentContext);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        super.endPrefixMapping(prefix);
        this.currentContext = this.currentContext.previous;
    }

    public UName parseUName(String qname2) throws SAXException {
        int idx = qname2.indexOf(58);
        if (idx < 0) {
            String uri = this.resolveNamespacePrefix("");
            if (uri.equals("") && this.chameleonMode) {
                uri = this.currentSchema.getTargetNamespace();
            }
            return new UName(uri, qname2, qname2);
        }
        String prefix = qname2.substring(0, idx);
        String uri = this.currentContext.resolveNamespacePrefix(prefix);
        if (uri == null) {
            this.reportError(Messages.format("UndefinedPrefix", prefix));
            uri = "undefined";
        }
        return new UName(uri, qname2.substring(idx + 1), qname2);
    }

    public boolean parseBoolean(String v) {
        if (v == null) {
            return false;
        }
        return (v = v.trim()).equals("true") || v.equals("1");
    }

    protected void unexpectedX(String token) throws SAXException {
        SAXParseException e = new SAXParseException(MessageFormat.format("Unexpected {0} appears at line {1} column {2}", token, new Integer(this.getLocator().getLineNumber()), new Integer(this.getLocator().getColumnNumber())), this.getLocator());
        this.parser.errorHandler.fatalError(e);
        throw e;
    }

    public ForeignAttributesImpl parseForeignAttributes(ForeignAttributesImpl next) {
        ForeignAttributesImpl impl = new ForeignAttributesImpl(this.createValidationContext(), this.copyLocator(), next);
        Attributes atts = this.getCurrentAttributes();
        for (int i = 0; i < atts.getLength(); ++i) {
            if (atts.getURI(i).length() <= 0) continue;
            impl.addAttribute(atts.getURI(i), atts.getLocalName(i), atts.getQName(i), atts.getType(i), atts.getValue(i));
        }
        return impl;
    }

    private static class Context
    implements ValidationContext {
        private final String prefix;
        private final String uri;
        private final Context previous;

        Context(String _prefix, String _uri, Context _context) {
            this.previous = _context;
            this.prefix = _prefix;
            this.uri = _uri;
        }

        public String resolveNamespacePrefix(String p) {
            if (p.equals(this.prefix)) {
                return this.uri;
            }
            if (this.previous == null) {
                return null;
            }
            return this.previous.resolveNamespacePrefix(p);
        }

        public String getBaseUri() {
            return null;
        }

        public boolean isNotation(String arg0) {
            return false;
        }

        public boolean isUnparsedEntity(String arg0) {
            return false;
        }
    }
}

