/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel;

import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationStringValue;
import com.sun.codemodel.JAnnotationValue;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JEnumConstant;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JGenerable;
import com.sun.codemodel.JType;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JAnnotationUse
extends JAnnotationValue {
    private final JClass clazz;
    private SortedMap<String, JAnnotationValue> memberValues;

    JAnnotationUse(JClass clazz) {
        this.clazz = clazz;
    }

    private JCodeModel owner() {
        return this.clazz.owner();
    }

    private void addValue(String name, JAnnotationValue annotationValue) {
        if (this.memberValues == null) {
            this.memberValues = new TreeMap<String, JAnnotationValue>();
        }
        this.memberValues.put(name, annotationValue);
    }

    public JAnnotationUse param(String name, boolean value) {
        this.addValue(name, new JAnnotationStringValue(JExpr.lit(value)));
        return this;
    }

    public JAnnotationUse param(String name, int value) {
        this.addValue(name, new JAnnotationStringValue(JExpr.lit(value)));
        return this;
    }

    public JAnnotationUse param(String name, String value) {
        this.addValue(name, new JAnnotationStringValue(JExpr.lit(value)));
        return this;
    }

    public JAnnotationUse annotationParam(String name, Class<? extends Annotation> value) {
        JAnnotationUse annotationUse = new JAnnotationUse(this.owner().ref(value));
        this.addValue(name, annotationUse);
        return annotationUse;
    }

    public JAnnotationUse param(String name, final Enum value) {
        this.addValue(name, new JAnnotationValue(){

            public void generate(JFormatter f) {
                f.t(JAnnotationUse.this.owner().ref(value.getDeclaringClass())).p('.').p(value.name());
            }
        });
        return this;
    }

    public JAnnotationUse param(String name, JEnumConstant value) {
        this.addValue(name, new JAnnotationStringValue(value));
        return this;
    }

    public JAnnotationUse param(String name, Class value) {
        this.addValue(name, new JAnnotationStringValue(JExpr.lit(value.getName())));
        return this;
    }

    public JAnnotationUse param(String name, JType type) {
        JClass clazz = type.boxify();
        this.addValue(name, new JAnnotationStringValue(clazz.dotclass()));
        return this;
    }

    public JAnnotationArrayMember paramArray(String name) {
        JAnnotationArrayMember arrayMember = new JAnnotationArrayMember(this.owner());
        this.addValue(name, arrayMember);
        return arrayMember;
    }

    public JAnnotationUse annotate(String className) {
        try {
            JAnnotationUse annotationUse = new JAnnotationUse(this.owner().ref(className));
            return annotationUse;
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    public JAnnotationUse annotate(Class<? extends Annotation> clazz) {
        JAnnotationUse annotationUse = new JAnnotationUse(this.owner().ref(clazz));
        return annotationUse;
    }

    @Override
    public void generate(JFormatter f) {
        f.p('@').g(this.clazz);
        if (this.memberValues != null) {
            f.p('(');
            boolean first = true;
            if (this.isOptimizable()) {
                f.g((JGenerable)this.memberValues.get("value"));
            } else {
                for (Map.Entry<String, JAnnotationValue> mapEntry : this.memberValues.entrySet()) {
                    if (!first) {
                        f.p(',');
                    }
                    f.p(mapEntry.getKey()).p('=').g(mapEntry.getValue());
                    first = false;
                }
            }
            f.p(')');
        }
    }

    private boolean isOptimizable() {
        return this.memberValues.size() == 1 && this.memberValues.firstKey().equals("value");
    }
}

