/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel;

import com.sun.codemodel.JExpression;
import com.sun.codemodel.JExpressionImpl;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JArray
extends JExpressionImpl {
    private final JType type;
    private final JExpression size;
    private List exprs = null;

    public JArray add(JExpression e) {
        if (this.exprs == null) {
            this.exprs = new ArrayList();
        }
        this.exprs.add(e);
        return this;
    }

    JArray(JType type, JExpression size) {
        this.type = type;
        this.size = size;
    }

    public void generate(JFormatter f) {
        int arrayCount = 0;
        JType t = this.type;
        while (t.isArray()) {
            t = t.elementType();
            ++arrayCount;
        }
        f.p("new").g(t).p('[');
        if (this.size != null) {
            f.g(this.size);
        }
        f.p(']');
        for (int i = 0; i < arrayCount; ++i) {
            f.p("[]");
        }
        if (this.size == null || this.exprs != null) {
            f.p('{');
        }
        if (this.exprs != null) {
            boolean first = true;
            if (this.exprs.size() > 0) {
                Iterator i = this.exprs.iterator();
                while (i.hasNext()) {
                    if (!first) {
                        f.p(',');
                    }
                    f.g((JExpression)i.next());
                    first = false;
                }
            }
        } else {
            f.p(' ');
        }
        if (this.size == null || this.exprs != null) {
            f.p('}');
        }
    }
}

