/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JAnonymousClass;
import com.sun.codemodel.JArrayClass;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JDeclaration;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JNullType;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JPrimitiveType;
import com.sun.codemodel.JType;
import com.sun.codemodel.JTypeVar;
import com.sun.codemodel.writer.FileCodeWriter;
import com.sun.codemodel.writer.ProgressCodeWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class JCodeModel {
    private HashMap packages = new HashMap();
    private final HashMap refClasses = new HashMap();
    public final JNullType NULL = new JNullType(this);
    public final JPrimitiveType VOID = new JPrimitiveType(this, "void", Void.class);
    public final JPrimitiveType BOOLEAN = new JPrimitiveType(this, "boolean", Boolean.class);
    public final JPrimitiveType BYTE = new JPrimitiveType(this, "byte", Byte.class);
    public final JPrimitiveType SHORT = new JPrimitiveType(this, "short", Short.class);
    public final JPrimitiveType CHAR = new JPrimitiveType(this, "char", Character.class);
    public final JPrimitiveType INT = new JPrimitiveType(this, "int", Integer.class);
    public final JPrimitiveType FLOAT = new JPrimitiveType(this, "float", Float.class);
    public final JPrimitiveType LONG = new JPrimitiveType(this, "long", Long.class);
    public final JPrimitiveType DOUBLE = new JPrimitiveType(this, "double", Double.class);
    protected static final boolean isCaseSensitiveFileSystem = JCodeModel.getFileSystemCaseSensitivity();
    public static final Map<Class, Class> primitiveToBox;
    public static final Map<Class, Class> boxToPrimitive;

    private static boolean getFileSystemCaseSensitivity() {
        try {
            if (System.getProperty("com.sun.codemodel.FileSystemCaseSensitive") != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return File.separatorChar == '/';
    }

    public JPackage _package(String name) {
        JPackage p = (JPackage)this.packages.get(name);
        if (p == null) {
            p = new JPackage(name, this);
            this.packages.put(name, p);
        }
        return p;
    }

    public final JPackage rootPackage() {
        return this._package("");
    }

    public Iterator packages() {
        return this.packages.values().iterator();
    }

    public JDefinedClass _class(String fullyqualifiedName) throws JClassAlreadyExistsException {
        return this._class(fullyqualifiedName, ClassType.CLASS);
    }

    public JDefinedClass _class(String fullyqualifiedName, ClassType t) throws JClassAlreadyExistsException {
        int idx = fullyqualifiedName.lastIndexOf(46);
        if (idx < 0) {
            return this.rootPackage()._class(fullyqualifiedName);
        }
        return this._package(fullyqualifiedName.substring(0, idx))._class(1, fullyqualifiedName.substring(idx + 1), t);
    }

    public JDefinedClass _getClass(String fullyQualifiedName) {
        int idx = fullyQualifiedName.lastIndexOf(46);
        if (idx < 0) {
            return this.rootPackage()._getClass(fullyQualifiedName);
        }
        return this._package(fullyQualifiedName.substring(0, idx))._getClass(fullyQualifiedName.substring(idx + 1));
    }

    public JDefinedClass newAnonymousClass(JClass baseType) {
        return new JAnonymousClass(baseType);
    }

    public JDefinedClass anonymousClass(JClass baseType) {
        return new JAnonymousClass(baseType);
    }

    public JDefinedClass anonymousClass(Class baseType) {
        return this.anonymousClass(this.ref(baseType));
    }

    public void build(File destDir, PrintStream status) throws IOException {
        this.build(destDir, destDir, status);
    }

    public void build(File srcDir, File resourceDir, PrintStream status) throws IOException {
        CodeWriter src = new FileCodeWriter(srcDir);
        CodeWriter res = new FileCodeWriter(resourceDir);
        if (status != null) {
            src = new ProgressCodeWriter(src, status);
            res = new ProgressCodeWriter(res, status);
        }
        this.build(src, res);
    }

    public void build(File destDir) throws IOException {
        this.build(destDir, System.out);
    }

    public void build(File srcDir, File resourceDir) throws IOException {
        this.build(srcDir, resourceDir, System.out);
    }

    public void build(CodeWriter out) throws IOException {
        this.build(out, out);
    }

    public void build(CodeWriter source, CodeWriter resource) throws IOException {
        JPackage[] pkgs;
        for (JPackage pkg : pkgs = this.packages.values().toArray(new JPackage[this.packages.size()])) {
            pkg.build(source, resource);
        }
        source.close();
        resource.close();
    }

    public JClass ref(Class clazz) {
        JReferencedClass jrc = (JReferencedClass)this.refClasses.get(clazz);
        if (jrc == null) {
            if (clazz.isPrimitive()) {
                throw new IllegalArgumentException(clazz + " is a primitive");
            }
            if (clazz.isArray()) {
                return new JArrayClass(this, this._ref(clazz.getComponentType()));
            }
            jrc = new JReferencedClass(clazz);
            this.refClasses.put(clazz, jrc);
        }
        return jrc;
    }

    public JType _ref(Class c) {
        if (c.isPrimitive()) {
            return JType.parse(this, c.getName());
        }
        return this.ref(c);
    }

    public JClass ref(String fullyQualifiedClassName) throws ClassNotFoundException {
        try {
            return this.ref(Thread.currentThread().getContextClassLoader().loadClass(fullyQualifiedClassName));
        }
        catch (ClassNotFoundException e) {
            return this.ref(Class.forName(fullyQualifiedClassName));
        }
    }

    public JType parseType(String name) throws ClassNotFoundException {
        if (name.endsWith("[]")) {
            return this.parseType(name.substring(0, name.length() - 2)).array();
        }
        try {
            return JType.parse(this, name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return this.ref(name);
        }
    }

    static {
        HashMap<Class<Void>, Class<Object>> m1 = new HashMap<Class<Void>, Class<Object>>();
        HashMap m2 = new HashMap();
        m1.put(Boolean.class, Boolean.TYPE);
        m1.put(Byte.class, Byte.TYPE);
        m1.put(Character.class, Character.TYPE);
        m1.put(Double.class, Double.TYPE);
        m1.put(Float.class, Float.TYPE);
        m1.put(Integer.class, Integer.TYPE);
        m1.put(Long.class, Long.TYPE);
        m1.put(Short.class, Short.TYPE);
        m1.put(Void.class, Void.TYPE);
        for (Map.Entry e : m1.entrySet()) {
            m2.put(e.getValue(), e.getKey());
        }
        boxToPrimitive = Collections.unmodifiableMap(m1);
        primitiveToBox = Collections.unmodifiableMap(m2);
    }

    private class JReferencedClass
    extends JClass
    implements JDeclaration {
        private final Class _class;

        JReferencedClass(Class _clazz) {
            super(JCodeModel.this);
            this._class = _clazz;
            if (this._class.isArray()) {
                throw new InternalError("assertion failure: class cannot be an array");
            }
        }

        private String getArrayName(String name) {
            int i = 1;
            while (name.charAt(i) == '[') {
                ++i;
            }
            String[] primitives = new String[]{"Bbyte", "Cchar", "Ddouble", "Ffloat", "Iint", "Jlong", "Sshort", "2boolean"};
            String r = null;
            for (int j = 0; j < primitives.length; ++j) {
                if (primitives[j].charAt(0) != name.charAt(i)) continue;
                r = primitives[j].substring(1);
            }
            if (r == null) {
                if (name.charAt(i) != 'L') {
                    throw new InternalError();
                }
                r = name.substring(i + 1, name.length() - 1);
            }
            while (i > 0) {
                r = r + "[]";
                --i;
            }
            return r;
        }

        public String name() {
            String name = this._class.getName();
            if (name.charAt(0) == '[') {
                return this.getArrayName(name);
            }
            int idx = name.lastIndexOf(46);
            if (idx < 0) {
                return name;
            }
            return name.substring(idx + 1);
        }

        public String fullName() {
            String name = this._class.getName();
            if (name.charAt(0) == '[') {
                return this.getArrayName(name);
            }
            return name;
        }

        public JPackage _package() {
            String name = this.fullName();
            if (name.indexOf(91) != -1) {
                return JCodeModel.this._package("");
            }
            int idx = name.lastIndexOf(46);
            if (idx < 0) {
                return JCodeModel.this._package("");
            }
            return JCodeModel.this._package(name.substring(0, idx));
        }

        public JClass _extends() {
            Class sp = this._class.getSuperclass();
            if (sp == null) {
                return null;
            }
            return JCodeModel.this.ref(sp);
        }

        public Iterator _implements() {
            final Class[] interfaces = this._class.getInterfaces();
            return new Iterator(){
                private int idx = 0;

                public boolean hasNext() {
                    return this.idx < interfaces.length;
                }

                public Object next() {
                    return JCodeModel.this.ref(interfaces[this.idx++]);
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public boolean isInterface() {
            return this._class.isInterface();
        }

        public boolean isAbstract() {
            return Modifier.isAbstract(this._class.getModifiers());
        }

        public JPrimitiveType getPrimitiveType() {
            if (this._class == Boolean.class) {
                return JCodeModel.this.BOOLEAN;
            }
            if (this._class == Byte.class) {
                return JCodeModel.this.BYTE;
            }
            if (this._class == Character.class) {
                return JCodeModel.this.CHAR;
            }
            if (this._class == Double.class) {
                return JCodeModel.this.DOUBLE;
            }
            if (this._class == Float.class) {
                return JCodeModel.this.FLOAT;
            }
            if (this._class == Integer.class) {
                return JCodeModel.this.INT;
            }
            if (this._class == Long.class) {
                return JCodeModel.this.LONG;
            }
            if (this._class == Short.class) {
                return JCodeModel.this.SHORT;
            }
            if (this._class == Void.class) {
                return JCodeModel.this.VOID;
            }
            return null;
        }

        public boolean isArray() {
            return this._class.isArray();
        }

        public void declare(JFormatter f) {
        }

        public JTypeVar[] typeParams() {
            return JTypeVar.EMPTY_ARRAY;
        }

        protected JClass substituteParams(JTypeVar[] variables, JClass[] bindings) {
            return this;
        }
    }
}

