/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JTypeVar;
import java.util.Iterator;

class JNarrowedClass
extends JClass {
    final JClass basis;
    private final JClass[] args;

    JNarrowedClass(JClass basis, JClass arg) {
        this(basis, new JClass[]{arg});
    }

    JNarrowedClass(JClass basis, JClass[] args) {
        super(basis.owner());
        this.basis = basis;
        assert (!(basis instanceof JNarrowedClass));
        this.args = args;
    }

    public JClass narrow(JClass clazz) {
        JClass[] newArgs = new JClass[this.args.length + 1];
        System.arraycopy(this.args, 0, newArgs, 0, this.args.length);
        newArgs[this.args.length] = clazz;
        return new JNarrowedClass(this.basis, newArgs);
    }

    public JClass narrow(JClass ... clazz) {
        JClass[] newArgs = new JClass[this.args.length + clazz.length];
        System.arraycopy(this.args, 0, newArgs, 0, this.args.length);
        System.arraycopy(clazz, 0, newArgs, this.args.length, clazz.length);
        return new JNarrowedClass(this.basis, newArgs);
    }

    public String name() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.basis.name());
        buf.append('<');
        for (int i = 0; i < this.args.length; ++i) {
            if (i != 0) {
                buf.append(',');
            }
            buf.append(this.args[i].name());
        }
        buf.append('>');
        return buf.toString();
    }

    public String fullName() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.basis.fullName());
        buf.append('<');
        for (int i = 0; i < this.args.length; ++i) {
            if (i != 0) {
                buf.append(',');
            }
            buf.append(this.args[i].fullName());
        }
        buf.append('>');
        return buf.toString();
    }

    public void generate(JFormatter f) {
        f.t(this.basis).p('<');
        for (int i = 0; i < this.args.length; ++i) {
            if (i != 0) {
                f.p(',');
            }
            f.g(this.args[i]);
        }
        f.p('\uffff');
    }

    public JPackage _package() {
        return this.basis._package();
    }

    public JClass _extends() {
        JClass base = this.basis._extends();
        if (base == null) {
            return base;
        }
        return base.substituteParams(this.basis.typeParams(), this.args);
    }

    public Iterator _implements() {
        return new Iterator(){
            private final Iterator core;
            {
                this.core = JNarrowedClass.this.basis._implements();
            }

            public void remove() {
                this.core.remove();
            }

            public Object next() {
                return ((JClass)this.core.next()).substituteParams(JNarrowedClass.this.basis.typeParams(), JNarrowedClass.this.args);
            }

            public boolean hasNext() {
                return this.core.hasNext();
            }
        };
    }

    public JClass erasure() {
        return this.basis;
    }

    public boolean isInterface() {
        return this.basis.isInterface();
    }

    public boolean isAbstract() {
        return this.basis.isAbstract();
    }

    public boolean isArray() {
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JNarrowedClass)) {
            return false;
        }
        return this.fullName().equals(((JClass)obj).fullName());
    }

    public int hashCode() {
        return this.fullName().hashCode();
    }

    public JTypeVar[] typeParams() {
        return JTypeVar.EMPTY_ARRAY;
    }

    protected JClass substituteParams(JTypeVar[] variables, JClass[] bindings) {
        JClass b = this.basis.substituteParams(variables, bindings);
        boolean different = b != this.basis;
        JClass[] clazz = new JClass[this.args.length];
        for (int i = 0; i < clazz.length; ++i) {
            clazz[i] = this.args[i].substituteParams(variables, bindings);
            different |= clazz[i] != this.args[i];
        }
        if (different) {
            return new JNarrowedClass(b, clazz);
        }
        return this;
    }

    public JClass getTypeParameter(int index) {
        return this.args[index];
    }
}

