/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDeclaration;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JPackage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class JTypeVar
extends JClass
implements JDeclaration {
    private final String name;
    private JClass classBound;
    private List interfaceBounds;
    static final JTypeVar[] EMPTY_ARRAY = new JTypeVar[0];

    JTypeVar(JCodeModel owner, String _name) {
        super(owner);
        this.name = _name;
    }

    public String name() {
        return this.name;
    }

    public String fullName() {
        return this.name;
    }

    public JPackage _package() {
        return null;
    }

    public JTypeVar bound(JClass c) {
        if (c.isInterface()) {
            if (this.interfaceBounds == null) {
                this.interfaceBounds = new ArrayList(1);
            }
            this.interfaceBounds.add(c);
        } else {
            if (this.classBound != null) {
                throw new IllegalArgumentException("type variable has an existing class bound " + this.classBound);
            }
            this.classBound = c;
        }
        return this;
    }

    public JClass _extends() {
        if (this.classBound != null) {
            return this.classBound;
        }
        return this.owner().ref(Object.class);
    }

    public Iterator _implements() {
        if (this.interfaceBounds == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.interfaceBounds.iterator();
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isAbstract() {
        return false;
    }

    public void declare(JFormatter f) {
        f.id(this.name);
        if (this.interfaceBounds != null) {
            f.p("extends");
            for (int i = 0; i < this.interfaceBounds.size(); ++i) {
                if (i != 0) {
                    f.p('&');
                }
                JClass c = (JClass)this.interfaceBounds.get(i);
                f.g(c);
            }
        }
    }

    public JTypeVar[] typeParams() {
        return EMPTY_ARRAY;
    }

    protected JClass substituteParams(JTypeVar[] variables, JClass[] bindings) {
        for (int i = 0; i < variables.length; ++i) {
            if (variables[i] != this) continue;
            return bindings[i];
        }
        return this;
    }

    public void generate(JFormatter f) {
        f.id(this.name);
    }
}

