/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel.ac;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAnnotationWriter;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class ACTask
extends Task {
    private final Path classpath;
    private final List<Classes> patterns = new ArrayList<Classes>();
    private ClassLoader userLoader;
    private JCodeModel codeModel = new JCodeModel();
    private JPackage pkg = this.codeModel.rootPackage();
    private File output = new File(".");
    private final Map<Class, JDefinedClass> queue = new HashMap<Class, JDefinedClass>();

    public ACTask() {
        this.classpath = new Path(null);
    }

    public void setProject(Project project) {
        super.setProject(project);
        this.classpath.setProject(project);
    }

    public void setPackage(String pkgName) {
        this.pkg = this.codeModel._package(pkgName);
    }

    public void setClasspath(Path cp) {
        this.classpath.createPath().append(cp);
    }

    public Path createClasspath() {
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.classpath.createPath().setRefid(r);
    }

    public void setDestdir(File output) {
        this.output = output;
    }

    public void addConfiguredClasses(Classes c) {
        this.patterns.add(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        this.userLoader = new AntClassLoader(this.getProject(), this.classpath);
        try {
            for (String path : this.classpath.list()) {
                File f = new File(path);
                if (f.isDirectory()) {
                    this.processDir(f, "");
                    continue;
                }
                this.processJar(f);
            }
            for (Map.Entry<Class, JDefinedClass> e : this.queue.entrySet()) {
                Class ann = e.getKey();
                JDefinedClass w = e.getValue();
                w._implements(this.codeModel.ref(JAnnotationWriter.class).narrow(ann));
                for (Method m : ann.getDeclaredMethods()) {
                    Class<?> rt = m.getReturnType();
                    if (rt.isArray()) {
                        rt = rt.getComponentType();
                    }
                    if (Annotation.class.isAssignableFrom(rt)) {
                        JDefinedClass at = this.queue.get(rt);
                        if (at == null) {
                            this.log(rt + " is not part of this compilation. ignored.", 2);
                            continue;
                        }
                        w.method(0, at, m.getName());
                        continue;
                    }
                    w.method(0, w, m.getName()).param(rt, "value");
                    if (rt != Class.class) continue;
                    w.method(0, w, m.getName()).param(JType.class, "value");
                }
            }
            try {
                this.codeModel.build(this.output);
            }
            catch (IOException e) {
                throw new BuildException("Unable to queue code to " + this.output, (Throwable)e);
            }
        }
        finally {
            this.userLoader = null;
        }
    }

    private void processJar(File jarfile) {
        try {
            JarFile jar = new JarFile(jarfile);
            Enumeration<JarEntry> en = jar.entries();
            while (en.hasMoreElements()) {
                JarEntry e = en.nextElement();
                this.process(e.getName(), e.getTime());
            }
        }
        catch (IOException e) {
            throw new BuildException("Unable to process " + jarfile, (Throwable)e);
        }
    }

    private void processDir(File dir, String prefix) {
        File[] subdirs;
        String[] classes;
        for (String c : classes = dir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".class");
            }
        })) {
            this.process(prefix + c, new File(dir, c).lastModified());
        }
        for (File f : subdirs = dir.listFiles(new FileFilter(){

            public boolean accept(File path) {
                return path.isDirectory();
            }
        })) {
            this.processDir(f, prefix + f.getName() + '/');
        }
    }

    private void process(String name, long timestamp) {
        if (!name.endsWith(".class")) {
            return;
        }
        name = name.substring(0, name.length() - 6);
        name = name.replace('/', '.');
        for (Classes c : this.patterns) {
            if (!c.include.matcher(name).matches() || c.exclude != null && c.exclude.matcher(name).matches()) continue;
            this.queue(name, timestamp);
            return;
        }
    }

    private void queue(String className, long timestamp) {
        JDefinedClass w;
        Class<?> ann;
        this.log("Processing " + className, 3);
        try {
            ann = this.userLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
        if (!Annotation.class.isAssignableFrom(ann)) {
            this.log("Skipping " + className + ". Not an annotation", 1);
            return;
        }
        try {
            w = this.pkg._class(1, ACTask.getShortName(className) + "Writer", ClassType.INTERFACE);
        }
        catch (JClassAlreadyExistsException e) {
            throw new BuildException("Class name collision on " + className, (Throwable)e);
        }
        String name = this.pkg.name();
        name = name.length() == 0 ? ACTask.getShortName(className) : name + '.' + ACTask.getShortName(className);
        File dst = new File(this.output, name.replace('.', File.separatorChar) + "Writer.java");
        if (dst.exists() && dst.lastModified() > timestamp) {
            this.log("Skipping " + className + ". Up to date.", 3);
            w.hide();
        }
        this.queue.put(ann, w);
    }

    private static String getShortName(String className) {
        int idx = className.lastIndexOf(46);
        if (idx < 0) {
            return className;
        }
        return className.substring(idx + 1);
    }

    public static class Classes {
        Pattern include;
        Pattern exclude;

        public void setIncludes(String pattern) {
            try {
                this.include = Pattern.compile(this.convertToRegex(pattern));
            }
            catch (PatternSyntaxException e) {
                throw new BuildException((Throwable)e);
            }
        }

        public void setExcludes(String pattern) {
            try {
                this.exclude = Pattern.compile(this.convertToRegex(pattern));
            }
            catch (PatternSyntaxException e) {
                throw new BuildException((Throwable)e);
            }
        }

        private String convertToRegex(String pattern) {
            StringBuilder regex = new StringBuilder();
            if (pattern.length() > 0) {
                for (int i = 0; i < pattern.length(); ++i) {
                    char c = pattern.charAt(i);
                    int j = i;
                    int nc = 32;
                    if (j + 1 != pattern.length()) {
                        nc = pattern.charAt(j + 1);
                    }
                    if (c == '.' && nc != 46) {
                        regex.append('\\');
                        regex.append('.');
                        continue;
                    }
                    if (c == '.' && nc == 46) continue;
                    if (c == '*' && nc == 42) {
                        regex.append(".*");
                        break;
                    }
                    if (c == '*') {
                        regex.append("[^\\.]+");
                        continue;
                    }
                    if (c == '?') {
                        regex.append("[^\\.]");
                        continue;
                    }
                    regex.append(c);
                }
            }
            return regex.toString();
        }
    }
}

