/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.txw2;

import com.sun.tools.txw2.ErrorListener;
import java.io.PrintStream;
import java.text.MessageFormat;
import org.xml.sax.SAXParseException;

public class ConsoleErrorReporter
implements ErrorListener {
    private final PrintStream out;

    public ConsoleErrorReporter(PrintStream out) {
        this.out = out;
    }

    public void error(SAXParseException exception) {
        this.out.print("[ERROR]   ");
        this.print(exception);
    }

    public void fatalError(SAXParseException exception) {
        this.out.print("[FATAL]   ");
        this.print(exception);
    }

    public void warning(SAXParseException exception) {
        this.out.print("[WARNING] ");
        this.print(exception);
    }

    private void print(SAXParseException e) {
        this.out.println(e.getMessage());
        this.out.println(MessageFormat.format("  {0}:{1} of {2}", String.valueOf(e.getLineNumber()), String.valueOf(e.getColumnNumber()), e.getSystemId()));
    }
}

