/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.txw2;

import com.sun.codemodel.writer.FileCodeWriter;
import com.sun.tools.txw2.AntErrorListener;
import com.sun.tools.txw2.Main;
import com.sun.tools.txw2.RELAXNGLoader;
import com.sun.tools.txw2.TxwOptions;
import com.sun.tools.txw2.XmlSchemaLoader;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.kohsuke.rngom.parse.compact.CompactParseable;
import org.kohsuke.rngom.parse.xml.SAXParseable;
import org.xml.sax.InputSource;

public class TxwTask
extends Task {
    private final TxwOptions options = new TxwOptions();
    private File schemaFile;
    private Style style = Style.AUTO_DETECT;

    public TxwTask() {
        this.options._package = this.options.codeModel.rootPackage();
        try {
            this.options.codeWriter = new FileCodeWriter(new File("."));
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setPackage(String pkg) {
        this.options._package = this.options.codeModel._package(pkg);
    }

    public void setSyntax(String style) {
        this.style = Style.valueOf(style.toUpperCase());
    }

    public void setSchema(File schema) {
        this.schemaFile = schema;
    }

    public void setDestdir(File dir) {
        try {
            this.options.codeWriter = new FileCodeWriter(dir);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setMethodChaining(boolean flg) {
        this.options.chainMethod = flg;
    }

    public void execute() throws BuildException {
        this.options.errorListener = new AntErrorListener(this.getProject());
        try {
            InputSource in = new InputSource(this.schemaFile.toURL().toExternalForm());
            String msg = "Compiling: " + in.getSystemId();
            this.log(msg, 2);
            if (this.style == Style.AUTO_DETECT) {
                String fileName = this.schemaFile.getPath().toLowerCase();
                this.style = fileName.endsWith("rnc") ? Style.COMPACT : (fileName.endsWith("xsd") ? Style.XMLSCHEMA : Style.XML);
            }
            switch (this.style) {
                case COMPACT: {
                    this.options.source = new RELAXNGLoader(new CompactParseable(in, this.options.errorListener));
                    break;
                }
                case XML: {
                    this.options.source = new RELAXNGLoader(new SAXParseable(in, this.options.errorListener));
                    break;
                }
                case XMLSCHEMA: {
                    this.options.source = new XmlSchemaLoader(in);
                }
            }
        }
        catch (MalformedURLException e) {
            throw new BuildException((Throwable)e);
        }
        Main.run(this.options);
        this.log("Compilation complete.", 2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Style {
        COMPACT,
        XML,
        XMLSCHEMA,
        AUTO_DETECT;

    }
}

