/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j.opts;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.kohsuke.args4j.opts.StringOption;

public class OutputStreamOption
extends StringOption {
    public OutputStreamOption(String optionName) {
        super(optionName, null);
    }

    public OutputStreamOption(String optionName, String defaultValue) {
        super(optionName, defaultValue);
    }

    public OutputStream createOutputStream() throws IOException {
        if (this.value == null) {
            return this.createNullStream();
        }
        if (this.value.equals("-")) {
            return this.createConsoleStream();
        }
        return new FileOutputStream(this.value);
    }

    protected OutputStream createNullStream() throws IOException {
        return new NullStream();
    }

    protected OutputStream createConsoleStream() throws IOException {
        return System.out;
    }

    public Writer createWriter() throws IOException {
        return new OutputStreamWriter(this.createOutputStream());
    }

    private final class NullStream
    extends OutputStream {
        private NullStream() {
        }

        public void write(byte[] b, int off, int len) {
        }

        public void write(byte[] b) {
        }

        public void write(int b) {
        }
    }
}

